/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;
import javax.crypto.SecretKey;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Digest
extends MessageDigestSpi
implements Cloneable {
    private static final int S_BLANK = 1;
    private static final int S_BUFFERED = 2;
    private static final int S_INIT = 3;
    private static final int BUFFER_SIZE = 96;
    private final Token token;
    private final String algorithm;
    private final CK_MECHANISM mechanism;
    private final int digestLength;
    private Session session;
    private int state;
    private byte[] buffer;
    private int bufOfs;

    P11Digest(Token token, String string, long l) {
        this.token = token;
        this.algorithm = string;
        this.mechanism = new CK_MECHANISM(l);
        switch ((int)l) {
            case 512: 
            case 528: {
                this.digestLength = 16;
                break;
            }
            case 544: {
                this.digestLength = 20;
                break;
            }
            case 597: {
                this.digestLength = 28;
                break;
            }
            case 592: {
                this.digestLength = 32;
                break;
            }
            case 608: {
                this.digestLength = 48;
                break;
            }
            case 624: {
                this.digestLength = 64;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + l);
            }
        }
        this.buffer = new byte[96];
        this.state = 1;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.digestLength;
    }

    private void fetchSession() {
        this.token.ensureValid();
        if (this.state == 1) {
            try {
                this.session = this.token.getOpSession();
                this.state = 2;
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new ProviderException("No more session available", pKCS11Exception);
            }
        }
    }

    @Override
    protected void engineReset() {
        this.token.ensureValid();
        if (this.session != null) {
            this.session = this.state == 3 && this.token.explicitCancel ? this.token.killSession(this.session) : this.token.releaseSession(this.session);
        }
        this.state = 1;
        this.bufOfs = 0;
    }

    @Override
    protected byte[] engineDigest() {
        try {
            byte[] byArray = new byte[this.digestLength];
            int n = this.engineDigest(byArray, 0, this.digestLength);
            return byArray;
        }
        catch (DigestException digestException) {
            throw new ProviderException("internal error", digestException);
        }
    }

    @Override
    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength);
        }
        this.fetchSession();
        try {
            int n3;
            if (this.state == 2) {
                n3 = this.token.p11.C_DigestSingle(this.session.id(), this.mechanism, this.buffer, 0, this.bufOfs, byArray, n, n2);
                this.bufOfs = 0;
            } else {
                if (this.bufOfs != 0) {
                    this.token.p11.C_DigestUpdate(this.session.id(), 0L, this.buffer, 0, this.bufOfs);
                    this.bufOfs = 0;
                }
                n3 = this.token.p11.C_DigestFinal(this.session.id(), byArray, n, n2);
            }
            if (n3 != this.digestLength) {
                throw new ProviderException("internal digest length error");
            }
            int n4 = n3;
            return n4;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("digest() failed", pKCS11Exception);
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.fetchSession();
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), this.mechanism);
                this.state = 3;
            }
            if (this.bufOfs != 0 && this.bufOfs + n2 > this.buffer.length) {
                this.token.p11.C_DigestUpdate(this.session.id(), 0L, this.buffer, 0, this.bufOfs);
                this.bufOfs = 0;
            }
            if (this.bufOfs + n2 > this.buffer.length) {
                this.token.p11.C_DigestUpdate(this.session.id(), 0L, byArray, n, n2);
            } else {
                System.arraycopy(byArray, n, this.buffer, this.bufOfs, n2);
                this.bufOfs += n2;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.engineReset();
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    protected void implUpdate(SecretKey secretKey) throws InvalidKeyException {
        if (!(secretKey instanceof P11Key)) {
            throw new InvalidKeyException("Not a P11Key: " + secretKey);
        }
        P11Key p11Key = (P11Key)((Object)secretKey);
        if (p11Key.token != this.token) {
            throw new InvalidKeyException("Not a P11Key of this provider: " + secretKey);
        }
        this.fetchSession();
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), this.mechanism);
                this.state = 3;
            }
            if (this.bufOfs != 0) {
                this.token.p11.C_DigestUpdate(this.session.id(), 0L, this.buffer, 0, this.bufOfs);
                this.bufOfs = 0;
            }
            this.token.p11.C_DigestKey(this.session.id(), p11Key.keyID);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.engineReset();
            throw new ProviderException("update(SecretKey) failed", pKCS11Exception);
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n <= 0) {
            return;
        }
        if (!(byteBuffer instanceof DirectBuffer)) {
            super.engineUpdate(byteBuffer);
            return;
        }
        this.fetchSession();
        long l = ((DirectBuffer)((Object)byteBuffer)).address();
        int n2 = byteBuffer.position();
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), this.mechanism);
                this.state = 3;
            }
            if (this.bufOfs != 0) {
                this.token.p11.C_DigestUpdate(this.session.id(), 0L, this.buffer, 0, this.bufOfs);
                this.bufOfs = 0;
            }
            this.token.p11.C_DigestUpdate(this.session.id(), l + (long)n2, null, 0, n);
            byteBuffer.position(n2 + n);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.engineReset();
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        P11Digest p11Digest = (P11Digest)super.clone();
        p11Digest.buffer = (byte[])this.buffer.clone();
        try {
            if (this.session != null) {
                p11Digest.session = p11Digest.token.getOpSession();
            }
            if (this.state == 3) {
                byte[] byArray = this.token.p11.C_GetOperationState(this.session.id());
                this.token.p11.C_SetOperationState(p11Digest.session.id(), byArray, 0L, 0L);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw (CloneNotSupportedException)new CloneNotSupportedException(this.algorithm).initCause(pKCS11Exception);
        }
        return p11Digest;
    }
}

