/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.services.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.services.routing.RouteMatch;
import org.forgerock.services.routing.RouteMatcher;
import org.forgerock.util.Pair;

public abstract class AbstractRouter<T extends AbstractRouter<T, R, H, D>, R, H, D>
implements Describable<D, R>,
Describable.Listener {
    private final Map<RouteMatcher<R>, H> routes = new ConcurrentHashMap<RouteMatcher<R>, H>();
    protected final RouteMatcher<R> thisRouterUriMatcher = this.uriMatcher(RoutingMode.EQUALS, "");
    private volatile H defaultRoute;
    private final List<Describable.Listener> apiListeners = new CopyOnWriteArrayList<Describable.Listener>();
    private ApiProducer<D> apiProducer;
    protected D api;
    private boolean apiNotificationsEnabled = true;

    protected AbstractRouter() {
    }

    protected AbstractRouter(AbstractRouter<T, R, H, D> router) {
        this.defaultRoute = router.defaultRoute;
        this.addAllRoutes(router);
    }

    protected abstract T getThis();

    protected final Map<RouteMatcher<R>, H> getRoutes() {
        return Collections.unmodifiableMap(this.routes);
    }

    public final T addAllRoutes(T router) {
        if (this != router) {
            boolean descriptorChanged = false;
            for (Map.Entry<RouteMatcher<R>, H> route : ((AbstractRouter)router).getRoutes().entrySet()) {
                H handler = route.getValue();
                descriptorChanged |= this.updateApiDescriptor(this.routes.put(route.getKey(), handler), handler);
            }
            if (descriptorChanged) {
                this.notifyDescriptorChange();
            }
        }
        return this.getThis();
    }

    public final T addRoute(RouteMatcher<R> matcher, H handler) {
        return this.updateApiDescriptorAndNotify(this.routes.put(matcher, handler), handler);
    }

    private boolean updateApiDescriptor(H oldHandler, H newHandler) {
        boolean oldHandlerDescribable = oldHandler instanceof Describable;
        boolean newHandlerDescribable = newHandler instanceof Describable;
        if (oldHandlerDescribable) {
            ((Describable)oldHandler).removeDescriptorListener(this);
        }
        if (newHandlerDescribable) {
            ((Describable)newHandler).addDescriptorListener(this);
        }
        return oldHandlerDescribable || newHandlerDescribable;
    }

    private T updateApiDescriptorAndNotify(H oldHandler, H newHandler) {
        if (this.updateApiDescriptor(oldHandler, newHandler)) {
            this.notifyDescriptorChange();
        }
        return this.getThis();
    }

    public final T setDefaultRoute(H handler) {
        H oldDefault = this.defaultRoute;
        this.defaultRoute = handler;
        return this.updateApiDescriptorAndNotify(oldDefault, handler);
    }

    final H getDefaultRoute() {
        return this.defaultRoute;
    }

    public final T removeAllRoutes() {
        this.routes.clear();
        this.api = null;
        return this.getThis();
    }

    @SafeVarargs
    public final boolean removeRoute(RouteMatcher<R> ... routes) {
        boolean isModified = false;
        boolean apiDescriptorModified = false;
        for (RouteMatcher<R> route : routes) {
            H removed = this.routes.remove(route);
            isModified |= removed != null;
            apiDescriptorModified |= this.updateApiDescriptor(removed, null);
        }
        if (apiDescriptorModified) {
            this.notifyDescriptorChange();
        }
        return isModified;
    }

    protected Pair<Context, H> getBestRoute(Context context, R request) throws IncomparableRouteMatchException {
        Pair<RouteMatch, H> bestMatch = this.getBestRouteMatch(context, request);
        if (bestMatch.getFirst() != null) {
            return Pair.of(bestMatch.getFirst().decorateContext(context), bestMatch.getSecond());
        }
        H dftRoute = this.defaultRoute;
        return dftRoute != null ? Pair.of(context, dftRoute) : null;
    }

    protected Pair<Context, H> getBestApiRoute(Context context, R request) throws IncomparableRouteMatchException {
        Pair<RouteMatch, H> bestMatch = this.getBestRouteMatch(context, request);
        Pair<RouteMatcher<R>, H> selfApiRoute = this.getSelfApiHandler();
        RouteMatch selfMatch = selfApiRoute.getFirst().evaluate(context, request);
        RouteMatch match = bestMatch.getFirst();
        if (selfMatch != null && selfMatch.isBetterMatchThan(match)) {
            return Pair.of(context, selfApiRoute.getSecond());
        }
        if (match != null) {
            return Pair.of(match.decorateContext(context), bestMatch.getSecond());
        }
        H dftRoute = this.defaultRoute;
        return dftRoute != null ? Pair.of(context, dftRoute) : null;
    }

    private Pair<RouteMatch, H> getBestRouteMatch(Context context, R request) throws IncomparableRouteMatchException {
        Pair<Object, Object> bestMatch = Pair.of(null, null);
        for (Map.Entry<RouteMatcher<R>, H> route : this.routes.entrySet()) {
            RouteMatch result = route.getKey().evaluate(context, request);
            if (result == null || !result.isBetterMatchThan(bestMatch.getFirst())) continue;
            bestMatch = Pair.of(result, route.getValue());
        }
        return bestMatch;
    }

    protected abstract Pair<RouteMatcher<R>, H> getSelfApiHandler();

    @Override
    public synchronized D api(ApiProducer<D> producer) {
        if (this.apiProducer == null) {
            this.apiProducer = producer;
            this.notifyDescriptorChange();
        }
        return this.api;
    }

    protected abstract RouteMatcher<R> uriMatcher(RoutingMode var1, String var2);

    @Override
    public D handleApiRequest(Context context, R request) {
        try {
            Object handler;
            Pair<Context, H> bestRoute = this.getBestApiRoute(context, request);
            Object v0 = handler = bestRoute != null ? bestRoute.getSecond() : null;
            if (handler instanceof Describable) {
                Context nextContext = bestRoute.getFirst();
                return ((Describable)handler).handleApiRequest(nextContext, request);
            }
        }
        catch (IncomparableRouteMatchException e) {
            throw new UnsupportedOperationException(e);
        }
        if (this.thisRouterUriMatcher.evaluate(context, request) != null) {
            return this.api;
        }
        throw new IllegalStateException("No route matched the request " + request);
    }

    private void notifyListeners() {
        for (Describable.Listener listener : this.apiListeners) {
            listener.notifyDescriptorChange();
        }
    }

    @Override
    public void addDescriptorListener(Describable.Listener listener) {
        this.apiListeners.add(listener);
    }

    @Override
    public void removeDescriptorListener(Describable.Listener listener) {
        this.apiListeners.remove(listener);
    }

    @Override
    public void notifyDescriptorChange() {
        if (this.apiProducer != null && this.apiNotificationsEnabled) {
            this.apiNotificationsEnabled = false;
            this.api = this.buildApi(this.apiProducer);
            this.apiNotificationsEnabled = true;
            this.notifyListeners();
        }
    }

    protected D buildApi(ApiProducer<D> producer) {
        ArrayList<D> descriptors = new ArrayList<D>(this.routes.size());
        for (Map.Entry<RouteMatcher<R>, H> route : this.routes.entrySet()) {
            H handler = route.getValue();
            if (!(handler instanceof Describable)) continue;
            RouteMatcher<R> matcher = route.getKey();
            D descriptor = ((Describable)handler).api(producer.newChildProducer(matcher.idFragment()));
            descriptors.add(matcher.transformApi(descriptor, producer));
        }
        H dftRoute = this.defaultRoute;
        if (dftRoute instanceof Describable) {
            descriptors.add(((Describable)dftRoute).api(producer));
        }
        return descriptors.isEmpty() ? null : (D)producer.merge(descriptors);
    }
}

