/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

public final class ConditionalFilters {
    public static final Condition ALWAYS_TRUE = new Condition(){

        @Override
        public boolean canApplyFilter(Context context, Request request) {
            return true;
        }
    };
    public static final Condition ALWAYS_FALSE = new Condition(){

        @Override
        public boolean canApplyFilter(Context context, Request request) {
            return false;
        }
    };
    public static final ConditionalFilter NEVER_APPLICABLE = ConditionalFilters.newConditionalFilter(new Filter(){

        @Override
        public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
            return Response.newResponsePromise(new Response(Status.NOT_IMPLEMENTED));
        }
    }, ALWAYS_FALSE);

    private ConditionalFilters() {
    }

    public static ConditionalFilter asConditionalFilter(Filter filter) {
        return ConditionalFilters.newConditionalFilter(filter, ALWAYS_TRUE);
    }

    public static ConditionalFilter newConditionalFilter(final Filter filter, final Condition condition) {
        Reject.checkNotNull(filter, "filter cannot be null");
        Reject.checkNotNull(condition, "condition cannot be null");
        return new ConditionalFilter(){

            @Override
            public Filter getFilter() {
                return filter;
            }

            @Override
            public Condition getCondition() {
                return condition;
            }
        };
    }

    public static interface Condition {
        public boolean canApplyFilter(Context var1, Request var2);
    }

    public static interface ConditionalFilter {
        public Filter getFilter();

        public Condition getCondition();
    }
}

