/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.rest2ldap.AbstractRequestHandler;
import org.forgerock.opendj.rest2ldap.DnTemplate;
import org.forgerock.opendj.rest2ldap.ReadOnlyRequestHandler;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.RoutingContext;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.Promise;

public abstract class SubResource {
    private final String resourceId;
    private DnTemplate dnTemplate;
    String urlTemplate = "";
    String dnTemplateString = "";
    boolean isReadOnly = false;
    Rest2Ldap rest2Ldap;
    Resource resource;

    SubResource(String resourceId) {
        this.resourceId = resourceId;
    }

    public final boolean equals(Object o) {
        return this == o || o instanceof SubResource && this.urlTemplate.equals(((SubResource)o).urlTemplate);
    }

    public final int hashCode() {
        return this.urlTemplate.hashCode();
    }

    public final String toString() {
        return this.urlTemplate;
    }

    final Resource getResource() {
        return this.resource;
    }

    final void build(Rest2Ldap rest2Ldap, String parent) {
        this.rest2Ldap = rest2Ldap;
        this.resource = rest2Ldap.getResource(this.resourceId);
        if (this.resource == null) {
            throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_UNRECOGNIZED_SUB_RESOURCE_TYPE.get(parent, this.resourceId));
        }
        this.dnTemplate = DnTemplate.compileRelative(this.dnTemplateString);
    }

    abstract Router addRoutes(Router var1);

    static <T> Function<ResourceException, T, ResourceException> convert404To400(final LocalizableMessage msg) {
        return new Function<ResourceException, T, ResourceException>(){

            @Override
            public T apply(ResourceException e) throws ResourceException {
                if (e instanceof NotFoundException) {
                    throw new BadRequestException(msg.toString());
                }
                throw e;
            }
        };
    }

    final RequestHandler readOnly(RequestHandler handler) {
        return this.isReadOnly ? new ReadOnlyRequestHandler(handler) : handler;
    }

    final Dn dnFrom(Context context) {
        return this.dnTemplate.format(context);
    }

    final RequestHandler subResourceRouterFrom(RoutingContext context) {
        return context.getType().getSubResourceRouter();
    }

    abstract Promise<RoutingContext, ResourceException> route(Context var1);

    final class SubResourceHandler
    extends AbstractRequestHandler {
        SubResourceHandler() {
        }

        @Override
        public Promise<ActionResponse, ResourceException> handleAction(Context context, final ActionRequest request) {
            return SubResource.this.route(context).thenAsync(new AsyncFunction<RoutingContext, ActionResponse, ResourceException>(){

                @Override
                public Promise<ActionResponse, ResourceException> apply(RoutingContext context) {
                    return SubResource.this.subResourceRouterFrom(context).handleAction(context, request);
                }
            });
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleCreate(Context context, final CreateRequest request) {
            return SubResource.this.route(context).thenAsync(new AsyncFunction<RoutingContext, ResourceResponse, ResourceException>(){

                @Override
                public Promise<ResourceResponse, ResourceException> apply(RoutingContext context) {
                    return SubResource.this.subResourceRouterFrom(context).handleCreate(context, request);
                }
            });
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleDelete(Context context, final DeleteRequest request) {
            return SubResource.this.route(context).thenAsync(new AsyncFunction<RoutingContext, ResourceResponse, ResourceException>(){

                @Override
                public Promise<ResourceResponse, ResourceException> apply(RoutingContext context) {
                    return SubResource.this.subResourceRouterFrom(context).handleDelete(context, request);
                }
            });
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handlePatch(Context context, final PatchRequest request) {
            return SubResource.this.route(context).thenAsync(new AsyncFunction<RoutingContext, ResourceResponse, ResourceException>(){

                @Override
                public Promise<ResourceResponse, ResourceException> apply(RoutingContext context) {
                    return SubResource.this.subResourceRouterFrom(context).handlePatch(context, request);
                }
            });
        }

        @Override
        public Promise<QueryResponse, ResourceException> handleQuery(Context context, final QueryRequest request, final QueryResourceHandler handler) {
            return SubResource.this.route(context).thenAsync(new AsyncFunction<RoutingContext, QueryResponse, ResourceException>(){

                @Override
                public Promise<QueryResponse, ResourceException> apply(RoutingContext context) {
                    return SubResource.this.subResourceRouterFrom(context).handleQuery(context, request, handler);
                }
            });
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleRead(Context context, final ReadRequest request) {
            return SubResource.this.route(context).thenAsync(new AsyncFunction<RoutingContext, ResourceResponse, ResourceException>(){

                @Override
                public Promise<ResourceResponse, ResourceException> apply(RoutingContext context) {
                    return SubResource.this.subResourceRouterFrom(context).handleRead(context, request);
                }
            });
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, final UpdateRequest request) {
            return SubResource.this.route(context).thenAsync(new AsyncFunction<RoutingContext, ResourceResponse, ResourceException>(){

                @Override
                public Promise<ResourceResponse, ResourceException> apply(RoutingContext context) {
                    return SubResource.this.subResourceRouterFrom(context).handleUpdate(context, request);
                }
            });
        }

        @Override
        public ApiDescription api(ApiProducer<ApiDescription> producer) {
            return SubResource.this.resource.subResourcesApi(producer);
        }
    }
}

