/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.protocol.Status;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.services.context.Context;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public final class ErrorLoggerFilter
implements Filter {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();

    @Override
    public Promise<Response, NeverThrowsException> filter(Context context, final Request request, Handler next) {
        return next.handle(context, request).thenOnResult(new ResultHandler<Response>(){

            @Override
            public void handleResult(Response response) {
                Exception cause = response.getCause();
                Status status = response.getStatus();
                if (status.isServerError() && cause != null) {
                    logger.error(Rest2ldapMessages.ERR_ERROR_RESPONSE, ErrorLoggerFilter.this.toLog(request), status.toString(), cause.getLocalizedMessage(), (Throwable)cause);
                }
            }
        }).thenCatchRuntimeException(new Function<RuntimeException, Response, NeverThrowsException>(){

            @Override
            public Response apply(RuntimeException e) {
                logger.error(Rest2ldapMessages.ERR_RUNTIME_EXCEPTION, ErrorLoggerFilter.this.toLog(request), e.getLocalizedMessage(), (Throwable)e);
                return Responses.newInternalServerError(e);
            }
        });
    }

    private String toLog(Request request) {
        return request.getMethod() + request.getUri();
    }
}

