/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldif.AbstractLdifWriter;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordVisitorWriter;
import org.forgerock.opendj.ldif.ChangeRecordWriter;
import org.forgerock.util.Reject;

public final class LdifChangeRecordWriter
extends AbstractLdifWriter
implements ChangeRecordWriter {
    private boolean hasChanged;

    public static String toString(ChangeRecord change) {
        StringWriter writer = new StringWriter(128);
        try (LdifChangeRecordWriter ldifWriter = new LdifChangeRecordWriter(writer);){
            ldifWriter.setAddUserFriendlyComments(true).writeChangeRecord(change);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public LdifChangeRecordWriter(List<String> ldifLines) {
        super(ldifLines);
    }

    public LdifChangeRecordWriter(OutputStream out) {
        super(out);
    }

    public LdifChangeRecordWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    @Override
    public void flush() throws IOException {
        this.flush0();
    }

    public LdifChangeRecordWriter setAddUserFriendlyComments(boolean addUserFriendlyComments) {
        this.addUserFriendlyComments = addUserFriendlyComments;
        return this;
    }

    public LdifChangeRecordWriter setExcludeAllOperationalAttributes(boolean excludeOperationalAttributes) {
        this.excludeOperationalAttributes = excludeOperationalAttributes;
        return this;
    }

    public LdifChangeRecordWriter setExcludeAllUserAttributes(boolean excludeUserAttributes) {
        this.excludeUserAttributes = excludeUserAttributes;
        return this;
    }

    public LdifChangeRecordWriter setExcludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull(attributeDescription);
        this.excludeAttributes.add(attributeDescription);
        return this;
    }

    public LdifChangeRecordWriter setExcludeBranch(Dn excludeBranch) {
        Reject.ifNull(excludeBranch);
        this.excludeBranches.add(excludeBranch);
        return this;
    }

    public LdifChangeRecordWriter setIncludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull(attributeDescription);
        this.includeAttributes.add(attributeDescription);
        return this;
    }

    public LdifChangeRecordWriter setIncludeBranch(Dn includeBranch) {
        Reject.ifNull(includeBranch);
        this.includeBranches.add(includeBranch);
        return this;
    }

    public LdifChangeRecordWriter setWrapColumn(int wrapColumn) {
        this.wrapColumn = wrapColumn;
        return this;
    }

    @Override
    public LdifChangeRecordWriter writeChangeRecord(AddRequest change) throws IOException {
        Reject.ifNull(change);
        if (this.isBranchExcluded(change.getName())) {
            return this;
        }
        this.hasChanged = true;
        this.writeKeyAndValue((CharSequence)"dn", change.getName().toString());
        this.writeControls(change.getControls());
        this.writeLine("changetype: add");
        for (Attribute attribute : change.getAllAttributes()) {
            if (this.isAttributeExcluded(attribute.getAttributeDescription())) continue;
            String attributeDescription = attribute.getAttributeDescriptionAsString();
            for (ByteString value : attribute) {
                this.writeKeyAndValue((CharSequence)attributeDescription, value);
            }
        }
        this.impl.println();
        return this;
    }

    @Override
    public LdifChangeRecordWriter writeChangeRecord(ChangeRecord change) throws IOException {
        Reject.ifNull(change);
        if (!this.isBranchExcluded(change.getName())) {
            change.accept(ChangeRecordVisitorWriter.getInstance(), this);
        }
        return this;
    }

    @Override
    public LdifChangeRecordWriter writeChangeRecord(DeleteRequest change) throws IOException {
        Reject.ifNull(change);
        if (this.isBranchExcluded(change.getName())) {
            return this;
        }
        this.hasChanged = true;
        this.writeKeyAndValue((CharSequence)"dn", change.getName().toString());
        this.writeControls(change.getControls());
        this.writeLine("changetype: delete");
        this.impl.println();
        return this;
    }

    @Override
    public LdifChangeRecordWriter writeChangeRecord(ModifyDnRequest change) throws IOException {
        Reject.ifNull(change);
        if (this.isBranchExcluded(change.getName())) {
            return this;
        }
        this.hasChanged = true;
        this.writeKeyAndValue((CharSequence)"dn", change.getName().toString());
        this.writeControls(change.getControls());
        if (change.getNewSuperior() != null) {
            this.writeLine("changetype: moddn");
        } else {
            this.writeLine("changetype: modrdn");
        }
        this.writeKeyAndValue((CharSequence)"newrdn", change.getNewRdn().toString());
        this.writeKeyAndValue((CharSequence)"deleteoldrdn", change.isDeleteOldRdn() ? "1" : "0");
        if (change.getNewSuperior() != null) {
            this.writeKeyAndValue((CharSequence)"newsuperior", change.getNewSuperior().toString());
        }
        this.impl.println();
        return this;
    }

    @Override
    public LdifChangeRecordWriter writeChangeRecord(ModifyRequest change) throws IOException {
        Reject.ifNull(change);
        if (change.getModifications().isEmpty()) {
            return this;
        }
        if (this.isBranchExcluded(change.getName())) {
            return this;
        }
        boolean headerWritten = false;
        for (Modification modification : change.getModifications()) {
            ModificationType type = modification.getModificationType();
            Attribute attribute = modification.getAttribute();
            String attributeDescription = attribute.getAttributeDescriptionAsString();
            if (this.isAttributeExcluded(attribute.getAttributeDescription())) continue;
            if (!headerWritten) {
                this.writeKeyAndValue((CharSequence)"dn", change.getName().toString());
                this.writeControls(change.getControls());
                this.writeLine("changetype: modify");
                headerWritten = true;
                this.hasChanged = true;
            }
            this.writeKeyAndValue((CharSequence)type.toString(), attributeDescription);
            for (ByteString value : attribute) {
                this.writeKeyAndValue((CharSequence)attributeDescription, value);
            }
            this.writeLine("-");
        }
        if (headerWritten) {
            this.impl.println();
        }
        return this;
    }

    @Override
    public LdifChangeRecordWriter writeComment(CharSequence comment) throws IOException {
        this.writeComment0(comment);
        return this;
    }

    public boolean containsChanges() {
        return this.hasChanged;
    }
}

