/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.messages.IntermediateResponse;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.spi.LdapPromiseImpl;
import org.forgerock.util.promise.PromiseImpl;

public abstract class ResultLdapPromiseImpl<R extends Request, S extends Result>
extends LdapPromiseImpl<S>
implements LdapPromise<S>,
IntermediateResponseHandler {
    private final R request;
    private IntermediateResponseHandler intermediateResponseHandler;
    private volatile long timestamp;

    ResultLdapPromiseImpl(PromiseImpl<S, LdapException> impl, int requestId, R request, IntermediateResponseHandler intermediateResponseHandler) {
        super(impl, requestId);
        this.request = request;
        this.intermediateResponseHandler = intermediateResponseHandler;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public final boolean handleIntermediateResponse(IntermediateResponse response) {
        if (!this.isDone()) {
            this.updateTimestamp();
            if (this.intermediateResponseHandler != null && !this.intermediateResponseHandler.handleIntermediateResponse(response)) {
                this.intermediateResponseHandler = null;
            }
        }
        return true;
    }

    public boolean isBindOrStartTls() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("( requestID = ");
        sb.append(this.getRequestId());
        sb.append(" timestamp = ");
        sb.append(this.timestamp);
        sb.append(" request = ");
        sb.append(this.getRequest());
        sb.append(" )");
        return sb.toString();
    }

    public final void adaptErrorResult(Result result) {
        S errorResult = this.newErrorResult(result.getResultCode(), result.getDiagnosticMessage(), result.getCause());
        this.setResultOrError(errorResult);
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    abstract S newErrorResult(ResultCode var1, CharSequence var2, Throwable var3);

    public final void setResultOrError(S result) {
        if (result.getResultCode().isExceptional()) {
            ((PromiseImpl)this.getWrappedPromise()).handleException(LdapException.newLdapException(result));
        } else {
            ((PromiseImpl)this.getWrappedPromise()).handleResult(result);
        }
    }

    public R getRequest() {
        return this.request;
    }

    final void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    public boolean checkForTimeout() {
        return true;
    }
}

