/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResult;
import org.forgerock.opendj.ldap.messages.WhoAmIExtendedResult;

final class WhoAmIExtendedResultImpl
extends AbstractExtendedResult<WhoAmIExtendedResult>
implements WhoAmIExtendedResult {
    private String authorizationId;

    WhoAmIExtendedResultImpl(ResultCode resultCode) {
        super(resultCode);
    }

    WhoAmIExtendedResultImpl(WhoAmIExtendedResult whoAmIExtendedResult) {
        super(whoAmIExtendedResult);
        this.authorizationId = whoAmIExtendedResult.getAuthorizationId();
    }

    @Override
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    @Override
    public String getOid() {
        return null;
    }

    @Override
    public ByteString getValue() {
        return this.authorizationId != null ? ByteString.valueOfUtf8(this.authorizationId) : null;
    }

    @Override
    public boolean hasValue() {
        return this.authorizationId != null;
    }

    @Override
    public WhoAmIExtendedResult setAuthorizationId(String authorizationId) {
        int colonIndex;
        if (authorizationId != null && authorizationId.length() != 0 && (colonIndex = authorizationId.indexOf(58)) < 0) {
            LocalizableMessage message = CoreMessages.ERR_WHOAMI_INVALID_AUTHZID_TYPE.get(authorizationId);
            throw new LocalizedIllegalArgumentException(message);
        }
        this.authorizationId = authorizationId;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WhoAmIExtendedResponse(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDn=");
        builder.append(this.getMatchedDn());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralUris());
        builder.append(", authzId=");
        builder.append(this.authorizationId);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

