/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.messages.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.WhoAmIExtendedRequest;
import org.forgerock.opendj.ldap.messages.WhoAmIExtendedResult;

final class WhoAmIExtendedRequestImpl
extends AbstractExtendedRequest<WhoAmIExtendedRequest, WhoAmIExtendedResult>
implements WhoAmIExtendedRequest {
    private static final ExtendedResultDecoder<WhoAmIExtendedResult> RESULT_DECODER = new ResultDecoder();

    WhoAmIExtendedRequestImpl() {
    }

    WhoAmIExtendedRequestImpl(WhoAmIExtendedRequest whoAmIExtendedRequest) {
        super(whoAmIExtendedRequest);
    }

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.4203.1.11.3";
    }

    @Override
    public ExtendedResultDecoder<WhoAmIExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WhoAmIExtendedRequest(requestName=");
        builder.append(this.getOid());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<WhoAmIExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public WhoAmIExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            if (result instanceof WhoAmIExtendedResult) {
                return (WhoAmIExtendedResult)result;
            }
            WhoAmIExtendedResult newResult = Responses.newWhoAmIExtendedResult(result.getResultCode()).setMatchedDn(result.getMatchedDn()).setDiagnosticMessage(result.getDiagnosticMessage());
            ByteString responseValue = result.getValue();
            if (responseValue != null) {
                try {
                    newResult.setAuthorizationId(responseValue.toString());
                }
                catch (LocalizedIllegalArgumentException e) {
                    throw DecodeException.error(e.getMessageObject());
                }
            }
            for (Control control : result.getControls()) {
                newResult.addControl(control);
            }
            return newResult;
        }

        @Override
        public WhoAmIExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, CharSequence diagnosticMessage) {
            return Responses.newWhoAmIExtendedResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }
    }

    static final class RequestDecoder
    implements ExtendedRequestDecoder<WhoAmIExtendedRequest, WhoAmIExtendedResult> {
        RequestDecoder() {
        }

        @Override
        public WhoAmIExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            WhoAmIExtendedRequestImpl newRequest = new WhoAmIExtendedRequestImpl();
            for (Control control : request.getControls()) {
                newRequest.addControl(control);
            }
            return newRequest;
        }
    }
}

