/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.messages.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.GenericExtendedRequest;
import org.forgerock.opendj.ldap.messages.GenericExtendedResult;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.util.Reject;

final class GenericExtendedRequestImpl
extends AbstractExtendedRequest<GenericExtendedRequest, GenericExtendedResult>
implements GenericExtendedRequest {
    private static final GenericExtendedResultDecoder RESULT_DECODER = new GenericExtendedResultDecoder();
    private String requestName;
    private ByteString requestValue;

    GenericExtendedRequestImpl(GenericExtendedRequest genericExtendedRequest) {
        super(genericExtendedRequest);
        this.requestName = genericExtendedRequest.getOid();
        this.requestValue = genericExtendedRequest.getValue();
    }

    GenericExtendedRequestImpl(String requestName) {
        this.requestName = requestName;
    }

    @Override
    public String getOid() {
        return this.requestName;
    }

    @Override
    public ExtendedResultDecoder<GenericExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getValue() {
        return this.requestValue;
    }

    @Override
    public boolean hasValue() {
        return this.requestValue != null;
    }

    @Override
    public GenericExtendedRequest setOid(String oid) {
        Reject.ifNull(oid);
        this.requestName = oid;
        return this;
    }

    @Override
    public GenericExtendedRequest setValue(Object value) {
        this.requestValue = value != null ? ByteString.valueOfObject(value) : null;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GenericExtendedRequest(requestName=");
        builder.append(this.getOid());
        if (this.hasValue()) {
            builder.append(", requestValue=");
            builder.append(this.getValue().toHexPlusAsciiString(4));
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class GenericExtendedResultDecoder
    extends AbstractExtendedResultDecoder<GenericExtendedResult> {
        private GenericExtendedResultDecoder() {
        }

        @Override
        public GenericExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            if (result instanceof GenericExtendedResult) {
                return (GenericExtendedResult)result;
            }
            GenericExtendedResult newResult = Responses.newGenericExtendedResult(result.getResultCode()).setMatchedDn(result.getMatchedDn()).setDiagnosticMessage(result.getDiagnosticMessage()).setOid(result.getOid()).setValue(result.getValue());
            for (Control control : result.getControls()) {
                newResult.addControl(control);
            }
            return newResult;
        }

        @Override
        public GenericExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, CharSequence diagnosticMessage) {
            return Responses.newGenericExtendedResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }
    }

    static final class RequestDecoder
    implements ExtendedRequestDecoder<GenericExtendedRequest, GenericExtendedResult> {
        RequestDecoder() {
        }

        @Override
        public GenericExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            if (request instanceof GenericExtendedRequest) {
                return (GenericExtendedRequest)request;
            }
            GenericExtendedRequest newRequest = new GenericExtendedRequestImpl(request.getOid()).setValue(request.getValue());
            for (Control control : request.getControls()) {
                newRequest.addControl(control);
            }
            return newRequest;
        }
    }
}

