/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.util.Arrays;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.messages.AbstractProtocolOpImpl;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.util.Reject;

final class BindRequestImpl
extends AbstractProtocolOpImpl<BindRequest>
implements BindRequest {
    static final String OBFUSCATED_PASSWORD = "******";
    private int version;
    private String name;
    private byte authenticationType;
    private byte[] authenticationValue;
    private String saslMechanism;
    private byte[] saslCredentials;
    private SaslClient saslClient;

    BindRequestImpl(BindRequest bindRequest) {
        super(bindRequest);
        this.version = bindRequest.getVersion();
        this.name = bindRequest.getName();
        this.authenticationType = bindRequest.getAuthenticationType();
        this.authenticationValue = StaticUtils.copyOfBytes(bindRequest.getAuthenticationValue());
        this.saslMechanism = bindRequest.getSaslMechanism();
        byte[] bytes = bindRequest.getSaslCredentials();
        this.saslCredentials = BindRequestImpl.copyOfBytesOrNull(bytes);
        this.saslClient = bindRequest.getSaslClient();
    }

    BindRequestImpl() {
        this.version = 3;
        this.name = "";
        this.authenticationType = (byte)-128;
        this.authenticationValue = StaticUtils.EMPTY_BYTES;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public BindRequest setVersion(int version) {
        Reject.ifTrue(version < 1 || version > 127, "version must be in range 1..127");
        this.version = version;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BindRequest setName(String name) {
        Reject.ifNull(name);
        this.name = name;
        return this;
    }

    @Override
    public byte getAuthenticationType() {
        return this.authenticationType;
    }

    @Override
    public byte[] getAuthenticationValue() {
        return StaticUtils.copyOfBytes(this.authenticationValue);
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public byte[] getSimplePassword() {
        return this.isSimpleBindRequest() ? StaticUtils.copyOfBytes(this.authenticationValue) : null;
    }

    @Override
    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    @Override
    public byte[] getSaslCredentials() {
        return BindRequestImpl.copyOfBytesOrNull(this.saslCredentials);
    }

    @Override
    public boolean isSimpleBindRequest() {
        return this.authenticationType == -128;
    }

    @Override
    public boolean isSaslBindRequest() {
        return this.authenticationType == -93;
    }

    @Override
    public BindRequest setAuthenticationTypeAndValue(byte type, byte[] value) throws IOException {
        Reject.ifNull((Object)value);
        String saslMechanism = null;
        byte[] saslCredentials = null;
        if (type == -93) {
            try (Asn1Reader reader = Asn1.getReader(value);){
                saslMechanism = reader.readOctetStringAsString();
                saslCredentials = reader.hasNextElement() ? reader.readOctetString().toByteArray() : null;
            }
        } else {
            this.saslClient = null;
        }
        this.setAuthenticationTypeAndValue0(type, value, saslMechanism, saslCredentials);
        return this;
    }

    private void setAuthenticationTypeAndValue0(byte type, byte[] value, String saslMechanism, byte[] saslCredentials) {
        this.authenticationType = type;
        this.authenticationValue = StaticUtils.copyOfBytes(value);
        this.saslMechanism = saslMechanism;
        this.saslCredentials = BindRequestImpl.copyOfBytesOrNull(saslCredentials);
    }

    @Override
    public BindRequest setSimplePassword(byte[] password) {
        Reject.ifNull((Object)password);
        this.setAuthenticationTypeAndValue0((byte)-128, password, null, null);
        this.saslClient = null;
        return this;
    }

    @Override
    public BindRequest setSaslMechanismAndCredentials(String mechanism, byte[] credentials) {
        Reject.ifNull(mechanism);
        ByteStringBuilder builder = new ByteStringBuilder();
        try (Asn1Writer writer = Asn1.getWriter(builder);){
            writer.writeOctetString(mechanism);
            if (credentials != null) {
                writer.writeOctetString(credentials);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setAuthenticationTypeAndValue0((byte)-93, builder.toByteArray(), mechanism, credentials);
        return this;
    }

    @Override
    public BindRequest setSaslMechanismAndCredentials(SaslClient saslClient) {
        Reject.ifNull(saslClient);
        try {
            byte[] credentials = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(StaticUtils.EMPTY_BYTES) : null;
            this.saslClient = saslClient;
            return this.setSaslMechanismAndCredentials(saslClient.getMechanismName(), credentials);
        }
        catch (SaslException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public SaslClient getSaslClient() {
        return this.saslClient;
    }

    @Override
    public BindRequest evaluateSaslChallenge(byte[] serverSaslCredentials) throws SaslException {
        Reject.ifNull((Object)serverSaslCredentials);
        if (this.saslClient == null) {
            throw new IllegalStateException("evaluateSASLChallenge invoked with null SaslClient");
        }
        if (this.saslClient.isComplete()) {
            return null;
        }
        byte[] nextCredentials = this.saslClient.evaluateChallenge(serverSaslCredentials);
        if (nextCredentials == null) {
            return null;
        }
        return Requests.copyOfBindRequest(this).setSaslMechanismAndCredentials(this.saslClient.getMechanismName(), nextCredentials);
    }

    @Override
    public boolean hasNegotiatedSaslQop() {
        if (this.saslClient == null) {
            throw new IllegalStateException("hasNegotiatedSASLQOP invoked with null SaslClient");
        }
        String qop = (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
        return qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"));
    }

    @Override
    public void destroy() {
        if (this.authenticationValue != null) {
            Arrays.fill(this.authenticationValue, (byte)0);
        }
        if (this.saslCredentials != null) {
            Arrays.fill(this.saslCredentials, (byte)0);
        }
    }

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.BIND;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BindRequest(version=");
        builder.append(this.version);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", authenticationType=");
        switch (this.authenticationType) {
            case -128: {
                builder.append("simple");
                builder.append(", password=");
                builder.append(OBFUSCATED_PASSWORD);
                break;
            }
            case -93: {
                builder.append("sasl");
                builder.append(", saslMechanism=");
                builder.append(this.saslMechanism);
                builder.append(", saslCredentials=");
                builder.append(this.saslCredentials != null ? OBFUSCATED_PASSWORD : "null");
                break;
            }
            default: {
                builder.append("unknown(");
                builder.append(this.authenticationType);
                builder.append("), authenticationValue=");
                builder.append(OBFUSCATED_PASSWORD);
            }
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    BindRequest getThis() {
        return this;
    }

    private static byte[] copyOfBytesOrNull(byte[] bytes) {
        return bytes != null ? StaticUtils.copyOfBytes(bytes) : null;
    }
}

