/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SearchScope {
    private static final SearchScope[] ELEMENTS = new SearchScope[4];
    private static final List<SearchScope> IMMUTABLE_ELEMENTS = Collections.unmodifiableList(Arrays.asList(ELEMENTS));
    public static final SearchScope BASE_OBJECT = SearchScope.register(0, "base", Enum.BASE_OBJECT);
    public static final SearchScope SINGLE_LEVEL = SearchScope.register(1, "one", Enum.SINGLE_LEVEL);
    public static final SearchScope WHOLE_SUBTREE = SearchScope.register(2, "sub", Enum.WHOLE_SUBTREE);
    public static final SearchScope SUBORDINATES = SearchScope.register(3, "subordinates", Enum.SUBORDINATES);
    private final int intValue;
    private final String name;
    private final Enum searchScopeEnum;

    public static SearchScope valueOf(int intValue) {
        SearchScope result = null;
        if (0 <= intValue && intValue < ELEMENTS.length) {
            result = ELEMENTS[intValue];
        }
        if (result == null) {
            result = new SearchScope(intValue, "unknown(" + intValue + ")", Enum.UNKNOWN);
        }
        return result;
    }

    public static SearchScope valueOf(String name) {
        for (SearchScope searchScope : ELEMENTS) {
            if (!searchScope.name.equals(name)) continue;
            return searchScope;
        }
        return null;
    }

    public static List<SearchScope> values() {
        return IMMUTABLE_ELEMENTS;
    }

    private static SearchScope register(int intValue, String name, Enum searchScopeEnum) {
        SearchScope t;
        SearchScope.ELEMENTS[intValue] = t = new SearchScope(intValue, name, searchScopeEnum);
        return t;
    }

    private SearchScope(int intValue, String name, Enum searchScopeEnum) {
        this.intValue = intValue;
        this.name = name;
        this.searchScopeEnum = searchScopeEnum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SearchScope) {
            return this.intValue == ((SearchScope)obj).intValue;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public Enum asEnum() {
        return this.searchScopeEnum;
    }

    public String toString() {
        return this.name;
    }

    public static enum Enum {
        BASE_OBJECT,
        SINGLE_LEVEL,
        WHOLE_SUBTREE,
        SUBORDINATES,
        UNKNOWN;

    }
}

