/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.ldap.controls.AffinityControl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.AbstractConnectionWrapper;
import org.forgerock.opendj.ldap.CachedConnectionPool;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConnectionLoadBalancer;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.ConsistentHashDistributionLoadBalancer;
import org.forgerock.opendj.ldap.ConsistentHashMap;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.InternalConnection;
import org.forgerock.opendj.ldap.InternalConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LoadBalancerEventListener;
import org.forgerock.opendj.ldap.NullConnectionFactory;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.RequestHandlerFactory;
import org.forgerock.opendj.ldap.RequestHandlerFactoryAdapter;
import org.forgerock.opendj.ldap.RequestLoadBalancer;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.UnbindRequest;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.time.Duration;

public final class Connections {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final Option<Duration> LOAD_BALANCER_MONITORING_INTERVAL = Option.withDefault(Duration.duration("1 seconds"));
    public static final Option<LoadBalancerEventListener> LOAD_BALANCER_EVENT_LISTENER = Option.of(LoadBalancerEventListener.class, LoadBalancerEventListener.LOG_EVENTS);
    public static final Option<ScheduledExecutorService> LOAD_BALANCER_SCHEDULER = Option.of(ScheduledExecutorService.class, null);
    public static final Option<Collection<Dn>> LOAD_BALANCER_PARTITION_BASE_DNS = Option.of(Collection.class, Collections.emptySet());
    private static final DecodeOptions CONTROL_DECODE_OPTIONS = new DecodeOptions();
    static final Function<Integer, Void, NeverThrowsException> NOOP_END_OF_REQUEST_FUNCTION = new Function<Integer, Void, NeverThrowsException>(){

        @Override
        public Void apply(Integer index) {
            return null;
        }
    };

    public static ConnectionPool newCachedConnectionPool(ConnectionFactory factory) {
        return new CachedConnectionPool(factory, 0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, null);
    }

    public static ConnectionPool newCachedConnectionPool(ConnectionFactory factory, int corePoolSize, int maximumPoolSize, long idleTimeout, TimeUnit unit) {
        return new CachedConnectionPool(factory, corePoolSize, maximumPoolSize, idleTimeout, unit, null);
    }

    public static ConnectionPool newCachedConnectionPool(ConnectionFactory factory, int corePoolSize, int maximumPoolSize, long idleTimeout, TimeUnit unit, ScheduledExecutorService scheduler) {
        return new CachedConnectionPool(factory, corePoolSize, maximumPoolSize, idleTimeout, unit, scheduler);
    }

    public static ConnectionPool newFixedConnectionPool(ConnectionFactory factory, int poolSize) {
        return new CachedConnectionPool(factory, poolSize, poolSize, 0L, null, null);
    }

    public static Connection newInternalConnection(RequestHandler<RequestContext> requestHandler) {
        Reject.ifNull(requestHandler);
        return Connections.newInternalConnection(RequestHandlerFactoryAdapter.adaptRequestHandler(requestHandler));
    }

    public static Connection newInternalConnection(ServerConnection<Integer> serverConnection) {
        Reject.ifNull(serverConnection);
        return new InternalConnection(serverConnection);
    }

    public static ConnectionFactory newInternalConnectionFactory(RequestHandler<RequestContext> requestHandler) {
        Reject.ifNull(requestHandler);
        return new InternalConnectionFactory<Object>(Connections.newServerConnectionFactory(requestHandler), null);
    }

    public static <C> ConnectionFactory newInternalConnectionFactory(RequestHandlerFactory<C, RequestContext> factory, C clientContext) {
        Reject.ifNull(factory);
        return new InternalConnectionFactory<C>(Connections.newServerConnectionFactory(factory), clientContext);
    }

    public static <C> ConnectionFactory newInternalConnectionFactory(ServerConnectionFactory<C, Integer> factory, C clientContext) {
        Reject.ifNull(factory);
        return new InternalConnectionFactory<C>(factory, clientContext);
    }

    public static ConnectionFactory newNullConnectionFactory() {
        return NullConnectionFactory.INSTANCE;
    }

    public static ConnectionFactory newNullConnectionFactory(String name, LocalizableMessage connectErrorMessage) {
        if (connectErrorMessage != null) {
            return new NullConnectionFactory(name, connectErrorMessage);
        }
        return NullConnectionFactory.INSTANCE;
    }

    public static ConnectionFactory newRoundRobinLoadBalancer(final Collection<? extends ConnectionFactory> factories, Options options) {
        return new ConnectionLoadBalancer("RoundRobinLoadBalancer", factories, options){
            private final int maxIndex;
            private final AtomicInteger nextIndex;
            {
                super(x0, x1, x2);
                this.maxIndex = factories.size();
                this.nextIndex = new AtomicInteger(-1);
            }

            @Override
            int getInitialConnectionFactoryIndex() {
                int newNextIndex;
                int oldNextIndex;
                if (this.maxIndex == 1) {
                    return 0;
                }
                do {
                    if ((newNextIndex = (oldNextIndex = this.nextIndex.get()) + 1) != this.maxIndex) continue;
                    newNextIndex = 0;
                } while (!this.nextIndex.compareAndSet(oldNextIndex, newNextIndex));
                return newNextIndex;
            }
        };
    }

    public static ConnectionFactory newFailoverLoadBalancer(Collection<? extends ConnectionFactory> factories, Options options) {
        return new ConnectionLoadBalancer("FailoverLoadBalancer", (Collection)factories, options){

            @Override
            int getInitialConnectionFactoryIndex() {
                return 0;
            }
        };
    }

    public static ConnectionFactory newAffinityRequestLoadBalancer(Collection<? extends ConnectionFactory> factories, Options options) {
        String connectionName = "AffinityRequestLoadBalancer";
        if (factories.isEmpty()) {
            return Connections.newNullConnectionFactory("AffinityRequestLoadBalancer", CoreMessages.ERR_NO_OPERATIONAL_CONNECTION_FACTORIES.get());
        }
        Collection<Dn> partitionBaseDns = options.get(LOAD_BALANCER_PARTITION_BASE_DNS);
        LeastRequestsDispatcher dispatcher = new LeastRequestsDispatcher(factories.size());
        return new RequestLoadBalancer("AffinityRequestLoadBalancer", factories, options, Connections.newAffinityRequestLoadBalancerNextFunction(factories, dispatcher, partitionBaseDns), Connections.newLeastRequestsLoadBalancerEndOfRequestFunction(dispatcher));
    }

    static Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> newAffinityRequestLoadBalancerNextFunction(Collection<? extends ConnectionFactory> factories, LeastRequestsDispatcher dispatcher, Collection<Dn> partitionBaseDns) {
        int maxPartitionId = factories.size();
        return partitionBaseDns.isEmpty() ? Connections.individualEntriesPartition(dispatcher, maxPartitionId) : Connections.subTreePartition(dispatcher, partitionBaseDns, maxPartitionId);
    }

    private static Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> individualEntriesPartition(final LeastRequestsDispatcher dispatcher, final int maxPartitionId) {
        final class IndividualEntriesPartition
        implements Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> {
            IndividualEntriesPartition() {
            }

            @Override
            public RequestLoadBalancer.PartitionedRequest apply(Request request) {
                if (Connections.isSubordinateSearch(request)) {
                    return new RequestLoadBalancer.PartitionedRequest(request, dispatcher.selectServer(-1));
                }
                Dn requestDn = Requests.dnOfRequest(request);
                int partitionId = Connections.computePartitionIdFromDn(requestDn, maxPartitionId);
                dispatcher.selectServer(partitionId);
                return new RequestLoadBalancer.PartitionedRequest(request, partitionId);
            }
        }
        return new IndividualEntriesPartition();
    }

    private static Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> subTreePartition(final LeastRequestsDispatcher dispatcher, final Collection<Dn> subTreeBaseDns, final int maxPartitionId) {
        final class SubtreePartition
        implements Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> {
            private final Set<Dn> partitionBaseDns;

            SubtreePartition() {
                this.partitionBaseDns = new HashSet<Dn>(subTreeBaseDns);
            }

            @Override
            public RequestLoadBalancer.PartitionedRequest apply(Request request) {
                Dn requestDn = Requests.dnOfRequest(request);
                if (requestDn == null) {
                    return new RequestLoadBalancer.PartitionedRequest(request, dispatcher.selectServer(-1));
                }
                Dn candidateBaseDn = requestDn;
                while (!this.partitionBaseDns.contains(candidateBaseDn) && !candidateBaseDn.isRootDn()) {
                    candidateBaseDn = candidateBaseDn.parent();
                }
                if (candidateBaseDn.isRootDn() || candidateBaseDn == requestDn) {
                    if (Connections.isSubordinateSearch(request)) {
                        return new RequestLoadBalancer.PartitionedRequest(request, dispatcher.selectServer(-1));
                    }
                    int partitionId = Connections.computePartitionIdFromDn(requestDn, maxPartitionId);
                    return new RequestLoadBalancer.PartitionedRequest(request, dispatcher.selectServer(partitionId));
                }
                Dn partitionDn = requestDn.parent(requestDn.size() - candidateBaseDn.size() - 1);
                int partitionId = dispatcher.selectServer(Connections.computePartitionIdFromDn(partitionDn, maxPartitionId));
                return new RequestLoadBalancer.PartitionedRequest(request, dispatcher.selectServer(partitionId));
            }
        }
        return new SubtreePartition();
    }

    private static boolean isSubordinateSearch(Request request) {
        return Request.RequestType.SEARCH.equals((Object)request.getType()) && !SearchScope.BASE_OBJECT.equals(((SearchRequest)request).getScope());
    }

    private static int computePartitionIdFromDn(Dn dn, int numberOfPartitions) {
        int partitionId = dn != null ? dn.hashCode() : ThreadLocalRandom.current().nextInt(0, numberOfPartitions);
        return partitionId == Integer.MIN_VALUE ? 0 : Math.abs(partitionId) % numberOfPartitions;
    }

    public static ConnectionFactory newFixedSizeDistributionLoadBalancer(Dn partitionBaseDN, ConsistentHashMap<? extends ConnectionFactory> partitions, Options options) {
        return new ConsistentHashDistributionLoadBalancer(partitionBaseDN, partitions);
    }

    public static ConnectionFactory newLeastRequestsLoadBalancer(Collection<? extends ConnectionFactory> factories, Options options) {
        String connectionName = "LeastRequestsLoadBalancer";
        if (factories.isEmpty()) {
            return Connections.newNullConnectionFactory("LeastRequestsLoadBalancer", CoreMessages.ERR_NO_OPERATIONAL_CONNECTION_FACTORIES.get());
        }
        LeastRequestsDispatcher dispatcher = new LeastRequestsDispatcher(factories.size());
        return new RequestLoadBalancer("LeastRequestsLoadBalancer", factories, options, Connections.newLeastRequestsLoadBalancerNextFunction(dispatcher), Connections.newLeastRequestsLoadBalancerEndOfRequestFunction(dispatcher));
    }

    static Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> newLeastRequestsLoadBalancerNextFunction(final LeastRequestsDispatcher dispatcher) {
        return new Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>(){
            private final int maxIndex;
            {
                this.maxIndex = dispatcher.size();
            }

            @Override
            public RequestLoadBalancer.PartitionedRequest apply(Request request) {
                int affinityBasedIndex = this.parseAffinityRequestControl(request);
                int finalIndex = dispatcher.selectServer(affinityBasedIndex);
                Request cleanedRequest = affinityBasedIndex == -1 ? request : Requests.shallowCopyOfRequest(request, "1.3.6.1.4.1.36733.2.1.5.2");
                return new RequestLoadBalancer.PartitionedRequest(cleanedRequest, finalIndex);
            }

            private int parseAffinityRequestControl(Request request) {
                try {
                    AffinityControl control = request.getControl(AffinityControl.DECODER, CONTROL_DECODE_OPTIONS);
                    if (control != null) {
                        int index = control.getAffinityValue().hashCode();
                        return index == Integer.MIN_VALUE ? 0 : Math.abs(index) % this.maxIndex;
                    }
                }
                catch (DecodeException e) {
                    logger.warn(CoreMessages.WARN_DECODING_AFFINITY_CONTROL.get(e.getMessage()));
                }
                return -1;
            }
        };
    }

    static Function<Integer, Void, NeverThrowsException> newLeastRequestsLoadBalancerEndOfRequestFunction(final LeastRequestsDispatcher dispatcher) {
        return new Function<Integer, Void, NeverThrowsException>(){

            @Override
            public Void apply(Integer index) {
                dispatcher.terminatedRequest(index);
                return null;
            }
        };
    }

    public static ConnectionFactory newNamedConnectionFactory(final ConnectionFactory factory, final String name) {
        Reject.ifNull(factory, name);
        return new ConnectionFactory(){

            @Override
            public void close() {
                factory.close();
            }

            @Override
            public Connection getConnection() throws LdapException {
                return factory.getConnection();
            }

            @Override
            public Promise<Connection, LdapException> getConnectionAsync() {
                return factory.getConnectionAsync();
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <C> ServerConnectionFactory<C, Integer> newServerConnectionFactory(final RequestHandler<RequestContext> requestHandler) {
        Reject.ifNull(requestHandler);
        return new RequestHandlerFactoryAdapter(new RequestHandlerFactory<C, RequestContext>(){

            @Override
            public RequestHandler<RequestContext> handleAccept(C clientContext) {
                return requestHandler;
            }
        });
    }

    public static <C> ServerConnectionFactory<C, Integer> newServerConnectionFactory(RequestHandlerFactory<C, RequestContext> factory) {
        Reject.ifNull(factory);
        return new RequestHandlerFactoryAdapter<C>(factory);
    }

    public static Connection uncloseable(Connection connection) {
        return new AbstractConnectionWrapper<Connection>(connection){

            @Override
            public void close() {
            }

            @Override
            public void close(UnbindRequest request, String reason) {
            }
        };
    }

    public static ConnectionFactory uncloseable(final ConnectionFactory factory) {
        return new ConnectionFactory(){

            @Override
            public Promise<Connection, LdapException> getConnectionAsync() {
                return factory.getConnectionAsync();
            }

            @Override
            public Connection getConnection() throws LdapException {
                return factory.getConnection();
            }

            @Override
            public void close() {
            }
        };
    }

    private Connections() {
    }

    static class LeastRequestsDispatcher {
        static final int LESS_SATURATED_SERVER = -1;
        private final AtomicLongArray serversCounters;

        LeastRequestsDispatcher(int numberOfServers) {
            this.serversCounters = new AtomicLongArray(numberOfServers);
        }

        int size() {
            return this.serversCounters.length();
        }

        int selectServer(int forceIndex) {
            int index = forceIndex == -1 ? this.getLessSaturatedIndex() : forceIndex;
            this.serversCounters.incrementAndGet(index);
            return index;
        }

        void terminatedRequest(Integer index) {
            this.serversCounters.decrementAndGet(index);
        }

        private int getLessSaturatedIndex() {
            long min = this.serversCounters.get(0);
            int minIndex = 0;
            for (int i = 1; i < this.serversCounters.length(); ++i) {
                long count = this.serversCounters.get(i);
                if (count >= min) continue;
                min = count;
                minIndex = i;
            }
            return minIndex;
        }
    }
}

