/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import java.io.IOException;
import java.util.List;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.io.Ldap;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.messages.AbandonRequest;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.IntermediateResponse;
import org.forgerock.opendj.ldap.messages.LdapMessage;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.ProtocolOp;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldap.messages.UnbindRequest;
import org.forgerock.opendj.ldap.messages.UnknownRequest;

public final class LdapWriter<W extends Asn1Writer> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final W writer;
    private final int protocolVersion;

    LdapWriter(W asn1Writer, int ldapVersion) {
        this.writer = asn1Writer;
        this.protocolVersion = ldapVersion;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public W getAsn1Writer() {
        return this.writer;
    }

    public void writeLdapMessage(LdapMessage ldapMessage) throws IOException {
        int messageID = ldapMessage.getMessageId();
        ProtocolOp protocolOp = ldapMessage.getProtocolOp();
        switch (ldapMessage.getProtocolOpType()) {
            case 80: {
                this.writeAbandonRequest(messageID, (AbandonRequest)protocolOp);
                break;
            }
            case 104: {
                this.writeAddRequest(messageID, (AddRequest)protocolOp);
                break;
            }
            case 105: {
                this.writeAddResult(messageID, (Result)protocolOp);
                break;
            }
            case 96: {
                this.writeBindRequest(messageID, (BindRequest)protocolOp);
                break;
            }
            case 97: {
                this.writeBindResult(messageID, (Result)protocolOp);
                break;
            }
            case 110: {
                this.writeCompareRequest(messageID, (CompareRequest)protocolOp);
                break;
            }
            case 111: {
                this.writeCompareResult(messageID, (Result)protocolOp);
                break;
            }
            case 74: {
                this.writeDeleteRequest(messageID, (DeleteRequest)protocolOp);
                break;
            }
            case 107: {
                this.writeDeleteResult(messageID, (Result)protocolOp);
                break;
            }
            case 119: {
                this.writeExtendedRequest(messageID, (ExtendedRequest)protocolOp);
                break;
            }
            case 120: {
                this.writeExtendedResult(messageID, (Result)protocolOp);
                break;
            }
            case 121: {
                this.writeIntermediateResponse(messageID, (IntermediateResponse)protocolOp);
                break;
            }
            case 108: {
                this.writeModifyDnRequest(messageID, (ModifyDnRequest)protocolOp);
                break;
            }
            case 109: {
                this.writeModifyDnResult(messageID, (Result)protocolOp);
                break;
            }
            case 102: {
                this.writeModifyRequest(messageID, (ModifyRequest)protocolOp);
                break;
            }
            case 103: {
                this.writeModifyResult(messageID, (Result)protocolOp);
                break;
            }
            case 99: {
                this.writeSearchRequest(messageID, (SearchRequest)protocolOp);
                break;
            }
            case 101: {
                this.writeSearchResult(messageID, (Result)protocolOp);
                break;
            }
            case 100: {
                this.writeSearchResultEntry(messageID, (SearchResultEntry)protocolOp);
                break;
            }
            case 115: {
                this.writeSearchResultReference(messageID, (SearchResultReference)protocolOp);
                break;
            }
            case 66: {
                this.writeUnbindRequest(messageID, (UnbindRequest)protocolOp);
                break;
            }
            default: {
                this.writeUnknownRequest(messageID, (UnknownRequest)protocolOp);
            }
        }
    }

    public void writeAbandonRequest(int messageID, AbandonRequest request) throws IOException {
        logger.trace("ENCODE LDAP ABANDON REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeInteger((byte)80, request.getRequestId());
        this.writeMessageFooter(request.getControls());
    }

    public void writeAddRequest(int messageID, AddRequest request) throws IOException {
        logger.trace("ENCODE LDAP ADD REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        Ldap.writeEntry(this.writer, (byte)104, this.adaptEntry(request));
        this.writeMessageFooter(request.getControls());
    }

    private Entry adaptEntry(Entry entry) {
        if (this.protocolVersion >= 3) {
            return entry;
        }
        LinkedHashMapEntry v2entry = new LinkedHashMapEntry(entry.getName());
        for (Attribute attribute : entry.getAllAttributes()) {
            v2entry.addAttribute(new LinkedAttribute(attribute.getAttributeDescription().withoutAnyOptions(), attribute));
        }
        return v2entry;
    }

    public void writeAddResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP ADD RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)105, result);
        this.writeResultFooter((Asn1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeBindRequest(int messageID, BindRequest request) throws IOException {
        logger.trace("ENCODE LDAP BIND REQUEST(messageID=%d, auth=0x%x, request=%s)", (Object)messageID, (Object)request.getAuthenticationType(), (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)96);
        this.writer.writeInteger(request.getVersion());
        this.writer.writeOctetString(request.getName());
        this.writer.writeOctetString(request.getAuthenticationType(), request.getAuthenticationValue());
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeBindResult(int messageID, Result result) throws IOException {
        BindResult bindResult;
        ByteString saslCredentials;
        logger.trace("ENCODE LDAP BIND RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)97, result);
        if (result instanceof BindResult && (saslCredentials = (bindResult = (BindResult)result).getServerSaslCredentials()) != null && saslCredentials.length() > 0) {
            this.writer.writeOctetString((byte)-121, saslCredentials);
        }
        this.writeResultFooter((Asn1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeCompareRequest(int messageID, CompareRequest request) throws IOException {
        logger.trace("ENCODE LDAP COMPARE REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)110);
        this.writer.writeOctetString(request.getName().toString());
        this.writer.writeStartSequence();
        this.writer.writeOctetString(request.getAttributeDescription().toString());
        this.writer.writeOctetString(request.getAssertionValue());
        this.writer.writeEndSequence();
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeCompareResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP COMPARE RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)111, result);
        this.writeResultFooter((Asn1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeControl(Control control) throws IOException {
        ByteString value;
        this.writer.writeStartSequence();
        this.writer.writeOctetString(control.getOid());
        if (control.isCritical()) {
            this.writer.writeBoolean(control.isCritical());
        }
        if ((value = control.getValue()) != null) {
            this.writer.writeOctetString(value);
        }
        this.writer.writeEndSequence();
    }

    public void writeDeleteRequest(int messageID, DeleteRequest request) throws IOException {
        logger.trace("ENCODE LDAP DELETE REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeOctetString((byte)74, request.getName().toString());
        this.writeMessageFooter(request.getControls());
    }

    public void writeDeleteResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP DELETE RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)107, result);
        this.writeResultFooter((Asn1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeExtendedRequest(int messageID, ExtendedRequest<?> request) throws IOException {
        logger.trace("ENCODE LDAP EXTENDED REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)119);
        this.writer.writeOctetString((byte)-128, request.getOid());
        ByteString requestValue = request.getValue();
        if (requestValue != null) {
            this.writer.writeOctetString((byte)-127, requestValue);
        }
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeExtendedResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP EXTENDED RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)120, result);
        if (result instanceof ExtendedResult) {
            ByteString responseValue;
            ExtendedResult extendedResult = (ExtendedResult)result;
            String responseName = extendedResult.getOid();
            if (responseName != null) {
                this.writer.writeOctetString((byte)-118, responseName);
            }
            if ((responseValue = extendedResult.getValue()) != null) {
                this.writer.writeOctetString((byte)-117, responseValue);
            }
        }
        this.writeResultFooter((Asn1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeIntermediateResponse(int messageID, IntermediateResponse response) throws IOException {
        ByteString responseValue;
        logger.trace("ENCODE LDAP INTERMEDIATE RESPONSE(messageID=%d, response=%s)", (Object)messageID, (Object)response);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)121);
        String responseName = response.getOid();
        if (responseName != null) {
            this.writer.writeOctetString((byte)-128, response.getOid());
        }
        if ((responseValue = response.getValue()) != null) {
            this.writer.writeOctetString((byte)-127, response.getValue());
        }
        this.writer.writeEndSequence();
        this.writeMessageFooter(response.getControls());
    }

    public void writeModifyDnRequest(int messageID, ModifyDnRequest request) throws IOException {
        logger.trace("ENCODE LDAP MODIFY DN REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)108);
        this.writer.writeOctetString(request.getName().toString());
        this.writer.writeOctetString(request.getNewRdn().toString());
        this.writer.writeBoolean(request.isDeleteOldRdn());
        Dn newSuperior = request.getNewSuperior();
        if (newSuperior != null) {
            this.writer.writeOctetString((byte)-128, newSuperior.toString());
        }
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeModifyDnResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP MODIFY DN RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)109, result);
        this.writeResultFooter((Asn1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeModifyRequest(int messageID, ModifyRequest request) throws IOException {
        logger.trace("ENCODE LDAP MODIFY REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)102);
        this.writer.writeOctetString(request.getName().toString());
        this.writer.writeStartSequence();
        for (Modification change : request.getModifications()) {
            this.writeChange(change);
        }
        this.writer.writeEndSequence();
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeModifyResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP MODIFY RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)103, result);
        this.writeResultFooter((Asn1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeSearchRequest(int messageID, SearchRequest request) throws IOException {
        logger.trace("ENCODE LDAP SEARCH REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)99);
        this.writer.writeOctetString(request.getName().toString());
        this.writer.writeEnumerated(request.getScope().intValue());
        this.writer.writeEnumerated(request.getDereferenceAliasesPolicy().intValue());
        this.writer.writeInteger(request.getSizeLimit());
        this.writer.writeInteger(request.getTimeLimit());
        this.writer.writeBoolean(request.isTypesOnly());
        Ldap.writeFilter(this.writer, request.getFilter());
        this.writer.writeStartSequence();
        for (String attribute : request.getAttributes()) {
            this.writer.writeOctetString(attribute);
        }
        this.writer.writeEndSequence();
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeSearchResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP SEARCH RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)101, result);
        this.writeResultFooter((Asn1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeSearchResultEntry(int messageID, SearchResultEntry entry) throws IOException {
        logger.trace("ENCODE LDAP SEARCH RESULT ENTRY(messageID=%d, entry=%s)", (Object)messageID, (Object)entry);
        this.writeMessageHeader(messageID);
        Ldap.writeEntry(this.writer, (byte)100, this.adaptEntry(entry));
        this.writeMessageFooter(entry.getControls());
    }

    public void writeSearchResultReference(int messageID, SearchResultReference reference) throws IOException {
        if (this.protocolVersion <= 2) {
            return;
        }
        logger.trace("ENCODE LDAP SEARCH RESULT REFERENCE(messageID=%d, reference=%s)", (Object)messageID, (Object)reference);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)115);
        for (String url : reference.getUris()) {
            this.writer.writeOctetString(url);
        }
        this.writer.writeEndSequence();
        this.writeMessageFooter(reference.getControls());
    }

    public void writeUnbindRequest(int messageID, UnbindRequest request) throws IOException {
        logger.trace("ENCODE LDAP UNBIND REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeNull((byte)66);
        this.writeMessageFooter(request.getControls());
    }

    public void writeUnknownRequest(int messageID, UnknownRequest unknownRequest) throws IOException {
        logger.trace("ENCODE LDAP UNKNOWN MESSAGE(messageID=%d, messageTag=%x, messageBytes=%s)", (Object)messageID, (Object)unknownRequest.getProtocolOpType(), (Object)unknownRequest.getRawProtocolOp());
        this.writeMessageHeader(messageID);
        this.writer.writeOctetString(unknownRequest.getProtocolOpType(), unknownRequest.getRawProtocolOp());
        this.writer.writeEndSequence();
    }

    private void writeChange(Modification change) throws IOException {
        this.writer.writeStartSequence();
        this.writer.writeEnumerated(change.getModificationType().intValue());
        Ldap.writeAttribute(this.writer, change.getAttribute());
        this.writer.writeEndSequence();
    }

    private void writeMessageFooter(List<Control> controls) throws IOException {
        if (!controls.isEmpty() && this.protocolVersion >= 3) {
            this.writer.writeStartSequence((byte)-96);
            for (Control control : controls) {
                this.writeControl(control);
            }
            this.writer.writeEndSequence();
        }
        this.writer.writeEndSequence();
    }

    private void writeMessageHeader(int messageID) throws IOException {
        this.writer.writeStartSequence();
        this.writer.writeInteger(messageID);
    }

    private void writeResultFooter(Asn1Writer writer) throws IOException {
        writer.writeEndSequence();
    }

    private void writeResultHeader(byte typeTag, Result rawMessage) throws IOException {
        List<String> referralURIs;
        this.writer.writeStartSequence(typeTag);
        this.writer.writeEnumerated(rawMessage.getResultCode().intValue());
        this.writer.writeOctetString(rawMessage.getMatchedDn());
        this.writer.writeOctetString(rawMessage.getDiagnosticMessage());
        if (this.protocolVersion >= 3 && !(referralURIs = rawMessage.getReferralUris()).isEmpty()) {
            this.writer.writeStartSequence((byte)-93);
            for (String s : referralURIs) {
                this.writer.writeOctetString(s);
            }
            this.writer.writeEndSequence();
        }
    }
}

