/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.FailFastErrorHandler;
import org.forgerock.json.schema.validator.ObjectValidatorFactory;
import org.forgerock.json.schema.validator.exceptions.SchemaException;
import org.forgerock.json.schema.validator.exceptions.ValidationException;
import org.forgerock.json.schema.validator.validators.NullTypeValidator;
import org.forgerock.json.schema.validator.validators.Validator;

public class UnionTypeValidator
extends Validator {
    private final List<Validator> validators;

    public UnionTypeValidator(Map<String, Object> schema, List<String> jsonPointer) {
        super(schema, jsonPointer);
        List unionTypes = (List)schema.get("type");
        this.validators = new ArrayList<Validator>(unionTypes.size());
        for (Object o : unionTypes) {
            if (o instanceof String) {
                this.validators.add(ObjectValidatorFactory.getTypeValidator((String)o, schema, jsonPointer));
                continue;
            }
            if (!(o instanceof Map)) continue;
            Validator v = ObjectValidatorFactory.getTypeValidator((Map)o, jsonPointer);
            this.validators.add(v);
            if (!(v instanceof NullTypeValidator)) continue;
            this.required = false;
        }
    }

    @Override
    public void validate(Object node, JsonPointer at, ErrorHandler handler) throws SchemaException {
        for (Validator v : this.validators) {
            try {
                v.validate(node, at, new FailFastErrorHandler());
                return;
            }
            catch (ValidationException validationException) {
            }
        }
        handler.error(new ValidationException("Invalid union validators.", this.getPath(at, null)));
    }
}

