/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Collection;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.promise.Promise;

public abstract class AbstractConnectionWrapper<C extends Connection>
implements Connection,
Describable<ApiDescription, Request> {
    protected final C connection;

    protected AbstractConnectionWrapper(C connection) {
        this.connection = connection;
    }

    protected Context transform(Context context) {
        return context;
    }

    @Override
    public ActionResponse action(Context context, ActionRequest request) throws ResourceException {
        return this.connection.action(this.transform(context), request);
    }

    @Override
    public Promise<ActionResponse, ResourceException> actionAsync(Context context, ActionRequest request) {
        return this.connection.actionAsync(this.transform(context), request);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public ResourceResponse create(Context context, CreateRequest request) throws ResourceException {
        return this.connection.create(this.transform(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> createAsync(Context context, CreateRequest request) {
        return this.connection.createAsync(this.transform(context), request);
    }

    @Override
    public ResourceResponse delete(Context context, DeleteRequest request) throws ResourceException {
        return this.connection.delete(this.transform(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> deleteAsync(Context context, DeleteRequest request) {
        return this.connection.deleteAsync(this.transform(context), request);
    }

    @Override
    public boolean isClosed() {
        return this.connection.isClosed();
    }

    @Override
    public boolean isValid() {
        return this.connection.isValid();
    }

    @Override
    public ResourceResponse patch(Context context, PatchRequest request) throws ResourceException {
        return this.connection.patch(this.transform(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> patchAsync(Context context, PatchRequest request) {
        return this.connection.patchAsync(this.transform(context), request);
    }

    @Override
    public QueryResponse query(Context context, QueryRequest request, QueryResourceHandler handler) throws ResourceException {
        return this.connection.query(this.transform(context), request, handler);
    }

    @Override
    public QueryResponse query(Context context, QueryRequest request, Collection<? super ResourceResponse> results) throws ResourceException {
        return this.connection.query(this.transform(context), request, results);
    }

    @Override
    public Promise<QueryResponse, ResourceException> queryAsync(Context context, QueryRequest request, QueryResourceHandler handler) {
        return this.connection.queryAsync(this.transform(context), request, handler);
    }

    @Override
    public ResourceResponse read(Context context, ReadRequest request) throws ResourceException {
        return this.connection.read(this.transform(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> readAsync(Context context, ReadRequest request) {
        return this.connection.readAsync(this.transform(context), request);
    }

    @Override
    public ResourceResponse update(Context context, UpdateRequest request) throws ResourceException {
        return this.connection.update(this.transform(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> updateAsync(Context context, UpdateRequest request) {
        return this.connection.updateAsync(this.transform(context), request);
    }

    @Override
    public ApiDescription api(ApiProducer<ApiDescription> producer) {
        if (this.connection instanceof Describable) {
            return ((Describable)this.connection).api(producer);
        }
        return null;
    }

    @Override
    public ApiDescription handleApiRequest(Context context, Request request) {
        if (this.connection instanceof Describable) {
            return (ApiDescription)((Describable)this.connection).handleApiRequest(context, request);
        }
        throw new UnsupportedOperationException("Connection is not describable");
    }

    @Override
    public void addDescriptorListener(Describable.Listener listener) {
        if (this.connection instanceof Describable) {
            ((Describable)this.connection).addDescriptorListener(listener);
        }
    }

    @Override
    public void removeDescriptorListener(Describable.Listener listener) {
        if (this.connection instanceof Describable) {
            ((Describable)this.connection).removeDescriptorListener(listener);
        }
    }
}

