/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum JwtClaimsSetKey {
    TYP,
    JTI,
    ISS,
    SUB,
    AUD,
    IAT,
    NBF,
    EXP,
    CUSTOM;

    private static final Map<String, JwtClaimsSetKey> NAME_MAP;
    private final String lowerCaseName = this.name().toLowerCase(Locale.ROOT);

    public String value() {
        return this.toString();
    }

    public static JwtClaimsSetKey getClaimSetKey(String claimSetKey) {
        JwtClaimsSetKey value;
        if (claimSetKey != null && !claimSetKey.isEmpty() && (value = NAME_MAP.get(claimSetKey.toLowerCase(Locale.ROOT))) != null) {
            return value;
        }
        return CUSTOM;
    }

    public String toString() {
        return this.lowerCaseName;
    }

    static {
        HashMap<String, JwtClaimsSetKey> temp = new HashMap<String, JwtClaimsSetKey>();
        for (JwtClaimsSetKey key : JwtClaimsSetKey.values()) {
            temp.put(key.lowerCaseName, key);
        }
        NAME_MAP = Collections.unmodifiableMap(temp);
    }
}

