/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwk.KeyUse;
import org.forgerock.json.jose.jwt.Algorithm;
import org.forgerock.json.jose.jwt.JWObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWKSet
extends JWObject {
    private static final Logger logger = LoggerFactory.getLogger(JWKSet.class);

    public JWKSet() {
        this.put("keys", Collections.emptyList());
    }

    public JWKSet(JWK jwk) {
        if (jwk == null) {
            throw new JsonException("JWK must not be null");
        }
        this.put("keys", Collections.singletonList(jwk.toJsonValue().asMap()));
    }

    public JWKSet(JsonValue jwks) {
        if (jwks == null) {
            throw new JsonException("JWK set must not be null");
        }
        this.put("keys", jwks.expect(List.class));
    }

    public JWKSet(List<JWK> jwkList) {
        if (jwkList == null) {
            throw new JsonException("The list cannot be null");
        }
        ArrayList<Map<String, Object>> jwkListAsJson = new ArrayList<Map<String, Object>>();
        for (JWK jwk : jwkList) {
            jwkListAsJson.add(jwk.toJsonValue().asMap());
        }
        this.put("keys", jwkListAsJson);
    }

    public List<JWK> getJWKsAsList() {
        LinkedList<JWK> listOfJWKs = new LinkedList<JWK>();
        JsonValue jwks = this.get("keys");
        for (JsonValue jwk : jwks) {
            listOfJWKs.add(JWK.parse(jwk));
        }
        return listOfJWKs;
    }

    public JsonValue getJWKsAsJsonValue() {
        return this.get("keys");
    }

    protected static JsonValue toJsonValue(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return new JsonValue(mapper.readValue(json, Map.class));
        }
        catch (IOException e) {
            throw new JsonException("Failed to parse json", e);
        }
    }

    public static JWKSet parse(String json) {
        JsonValue jwkSet = new JsonValue(JWKSet.toJsonValue(json));
        return JWKSet.parse(jwkSet);
    }

    public static JWKSet parse(JsonValue json) {
        if (json == null) {
            throw new JsonException("Cant parse JWKSet. No json data.");
        }
        return new JWKSet(json.get("keys"));
    }

    public String toJsonString() {
        return super.toString();
    }

    public JWK findJwk(Algorithm algorithm, KeyUse keyUse) {
        for (JWK jwk : this.getJWKsAsList()) {
            try {
                if (!algorithm.equals(jwk.getJwaAlgorithm()) || keyUse != jwk.getUse()) continue;
                return jwk;
            }
            catch (IllegalArgumentException e) {
                logger.warn("Can't load JWK with kid'" + jwk.getKeyId() + "'", e);
            }
        }
        return keyUse != null ? this.findJwk(algorithm, null) : null;
    }

    public JWK findJwk(String kid) {
        for (JWK jwk : this.getJWKsAsList()) {
            if (!kid.equals(jwk.getKeyId())) continue;
            return jwk;
        }
        return null;
    }
}

