/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Cookie;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Request;

public class CookieHeader
extends Header {
    public static final String NAME = "Cookie";
    private final List<Cookie> cookies;

    private static CookieHeader valueOf(List<String> values) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(values.size());
        Integer version = null;
        Cookie cookie = new Cookie();
        for (String s1 : values) {
            for (String s2 : HeaderUtil.split(s1, ';')) {
                HeaderUtil.Parameter parameter = HeaderUtil.parseParameter(s2);
                if (parameter.hasName() && parameter.getName().charAt(0) != '$') {
                    if (cookie.getName() != null) {
                        cookies.add(cookie);
                    }
                    cookie = new Cookie();
                    cookie.setVersion(version);
                    cookie.setName(parameter.getName());
                    cookie.setValue(parameter.getValue());
                    cookie.setValueWasQuoted(parameter.wasQuoted());
                    continue;
                }
                if ("$Version".equalsIgnoreCase(parameter.getName())) {
                    version = CookieHeader.parseInteger(parameter.getValue());
                    cookie.setVersion(version);
                    continue;
                }
                if ("$Path".equalsIgnoreCase(parameter.getName())) {
                    cookie.setPath(parameter.getValue());
                    continue;
                }
                if ("$Domain".equalsIgnoreCase(parameter.getName())) {
                    cookie.setDomain(parameter.getValue());
                    continue;
                }
                if (!"$Port".equalsIgnoreCase(parameter.getName())) continue;
                cookie.getPort().clear();
                CookieHeader.parsePorts(cookie.getPort(), parameter.getValue());
            }
        }
        if (cookie.getName() != null) {
            cookies.add(cookie);
        }
        return new CookieHeader(cookies);
    }

    private static void parsePorts(List<Integer> list, String s) {
        for (String port : s.split(",")) {
            Integer p = CookieHeader.parseInteger(port);
            if (p == null) continue;
            list.add(p);
        }
    }

    private static Integer parseInteger(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static CookieHeader valueOf(Request message) {
        return CookieHeader.valueOf(HeaderUtil.parseMultiValuedHeader(message, NAME));
    }

    public static CookieHeader valueOf(String string) {
        return CookieHeader.valueOf(HeaderUtil.parseMultiValuedHeader(string));
    }

    public CookieHeader() {
        this(new ArrayList<Cookie>(1));
    }

    public CookieHeader(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        boolean quoted = false;
        Integer version = null;
        for (Cookie cookie : this.cookies) {
            if (cookie.getVersion() != null && (version == null || cookie.getVersion() > version)) {
                version = cookie.getVersion();
                continue;
            }
            if (version != null || cookie.getPath() == null && cookie.getDomain() == null) continue;
            version = 1;
        }
        StringBuilder sb = new StringBuilder();
        if (version != null) {
            sb.append("$Version=").append(version.toString());
            quoted = true;
        }
        for (Cookie cookie : this.cookies) {
            if (cookie.getName() == null) continue;
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(cookie.getName()).append('=');
            sb.append(quoted || cookie.valueWasQuoted() ? HeaderUtil.quote(cookie.getValue()) : cookie.getValue());
            if (cookie.getPath() != null) {
                sb.append("; $Path=").append(HeaderUtil.quote(cookie.getPath()));
            }
            if (cookie.getDomain() != null) {
                sb.append("; $Domain=").append(HeaderUtil.quote(cookie.getDomain()));
            }
            if (cookie.getPort().size() <= 0) continue;
            sb.append("; $Port=").append(HeaderUtil.quote(this.portList(cookie.getPort())));
        }
        return sb.length() > 0 ? Collections.singletonList(sb.toString()) : Collections.emptyList();
    }

    private String portList(List<Integer> ports) {
        StringBuilder sb = new StringBuilder();
        for (Integer port : ports) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(port.toString());
        }
        return sb.toString();
    }

    static class Factory
    extends HeaderFactory<CookieHeader> {
        Factory() {
        }

        @Override
        public CookieHeader parse(String value) {
            return CookieHeader.valueOf(value);
        }

        @Override
        public CookieHeader parse(List<String> values) {
            return CookieHeader.valueOf(values);
        }
    }
}

