/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.transform;

import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Objects;
import org.forgerock.api.transform.LocalizableProperty;
import org.forgerock.util.i18n.LocalizableString;

class LocalizableStringProperty
extends StringProperty
implements LocalizableProperty<Property> {
    private LocalizableString title;
    private LocalizableString description;

    LocalizableStringProperty() {
    }

    @Override
    public LocalizableStringProperty title(LocalizableString title) {
        this.title = title;
        return this;
    }

    @Override
    public LocalizableStringProperty description(LocalizableString desc) {
        this.description = desc;
        return this;
    }

    @Override
    public LocalizableStringProperty title(String title) {
        this.setTitle(title);
        return this;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.title = new LocalizableString(title);
    }

    @Override
    public LocalizableStringProperty description(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        this.description = new LocalizableString(description);
    }

    @Override
    public LocalizableString getLocalizableTitle() {
        return this.title;
    }

    @Override
    public LocalizableString getLocalizableDescription() {
        return this.description;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LocalizableStringProperty)) {
            return false;
        }
        LocalizableStringProperty other = (LocalizableStringProperty)o;
        if (!Objects.equals(this.title, other.title)) {
            return false;
        }
        return Objects.equals(this.description, other.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.title, this.description);
    }
}

