/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.transform;

import io.swagger.models.properties.ArrayProperty;
import java.util.List;
import java.util.Objects;
import org.forgerock.api.transform.LocalizableProperty;
import org.forgerock.util.i18n.LocalizableString;

class LocalizableArrayProperty
extends ArrayProperty
implements LocalizableProperty<ArrayProperty> {
    private LocalizableString title;
    private LocalizableString description;
    private List<Object> defaultValue;

    LocalizableArrayProperty() {
    }

    @Override
    public LocalizableArrayProperty title(LocalizableString title) {
        this.title = title;
        return this;
    }

    @Override
    public LocalizableArrayProperty description(LocalizableString desc) {
        this.description = desc;
        return this;
    }

    @Override
    public LocalizableArrayProperty title(String title) {
        this.setTitle(title);
        return this;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.title = new LocalizableString(title);
    }

    @Override
    public LocalizableArrayProperty description(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        this.description = new LocalizableString(description);
    }

    @Override
    public LocalizableString getLocalizableTitle() {
        return this.title;
    }

    @Override
    public LocalizableString getLocalizableDescription() {
        return this.description;
    }

    public void setDefault(List<Object> defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<Object> getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LocalizableArrayProperty)) {
            return false;
        }
        LocalizableArrayProperty other = (LocalizableArrayProperty)o;
        if (this.defaultValue == null) {
            if (other.defaultValue != null) {
                return false;
            }
        } else {
            if (other.defaultValue == null) {
                return false;
            }
            if (!this.defaultValue.containsAll(other.defaultValue) || !other.defaultValue.containsAll(this.defaultValue)) {
                return false;
            }
        }
        if (!Objects.equals(this.title, other.title)) {
            return false;
        }
        return Objects.equals(this.description, other.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.title, this.description, this.defaultValue);
    }
}

