/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observables.ConnectableObservable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public final class ObservableRefCount<T>
extends AbstractObservableWithUpstream<T, T> {
    final ConnectableObservable<? extends T> source;
    volatile CompositeDisposable baseDisposable = new CompositeDisposable();
    final AtomicInteger subscriptionCount = new AtomicInteger();
    final ReentrantLock lock = new ReentrantLock();

    public ObservableRefCount(ConnectableObservable<T> source) {
        super(source);
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeActual(Observer<? super T> subscriber) {
        this.lock.lock();
        if (this.subscriptionCount.incrementAndGet() == 1) {
            AtomicBoolean writeLocked = new AtomicBoolean(true);
            try {
                this.source.connect(this.onSubscribe(subscriber, writeLocked));
            }
            finally {
                if (writeLocked.get()) {
                    this.lock.unlock();
                }
            }
        }
        try {
            this.doSubscribe(subscriber, this.baseDisposable);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Consumer<Disposable> onSubscribe(final Observer<? super T> observer, final AtomicBoolean writeLocked) {
        return new Consumer<Disposable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Disposable subscription) {
                try {
                    ObservableRefCount.this.baseDisposable.add(subscription);
                    ObservableRefCount.this.doSubscribe(observer, ObservableRefCount.this.baseDisposable);
                }
                finally {
                    ObservableRefCount.this.lock.unlock();
                    writeLocked.set(false);
                }
            }
        };
    }

    void doSubscribe(Observer<? super T> observer, CompositeDisposable currentBase) {
        Disposable d = this.disconnect(currentBase);
        ConnectionObserver s = new ConnectionObserver(observer, currentBase, d);
        observer.onSubscribe(s);
        this.source.subscribe(s);
    }

    private Disposable disconnect(final CompositeDisposable current) {
        return Disposables.fromRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObservableRefCount.this.lock.lock();
                try {
                    if (ObservableRefCount.this.baseDisposable == current && ObservableRefCount.this.subscriptionCount.decrementAndGet() == 0) {
                        ObservableRefCount.this.baseDisposable.dispose();
                        ObservableRefCount.this.baseDisposable = new CompositeDisposable();
                    }
                }
                finally {
                    ObservableRefCount.this.lock.unlock();
                }
            }
        });
    }

    final class ConnectionObserver
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 3813126992133394324L;
        final Observer<? super T> subscriber;
        final CompositeDisposable currentBase;
        final Disposable resource;

        ConnectionObserver(Observer<? super T> subscriber, CompositeDisposable currentBase, Disposable resource) {
            this.subscriber = subscriber;
            this.currentBase = currentBase;
            this.resource = resource;
        }

        @Override
        public void onSubscribe(Disposable s) {
            DisposableHelper.setOnce(this, s);
        }

        @Override
        public void onError(Throwable e) {
            this.cleanup();
            this.subscriber.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.subscriber.onNext(t);
        }

        @Override
        public void onComplete() {
            this.cleanup();
            this.subscriber.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            this.resource.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() {
            ObservableRefCount.this.lock.lock();
            try {
                if (ObservableRefCount.this.baseDisposable == this.currentBase) {
                    ObservableRefCount.this.baseDisposable.dispose();
                    ObservableRefCount.this.baseDisposable = new CompositeDisposable();
                    ObservableRefCount.this.subscriptionCount.set(0);
                }
            }
            finally {
                ObservableRefCount.this.lock.unlock();
            }
        }
    }
}

