/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.UnicastProcessor;
import io.reactivex.subscribers.DisposableSubscriber;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindowBoundary<T, B>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final Publisher<B> other;
    final int bufferSize;

    public FlowableWindowBoundary(Publisher<T> source, Publisher<B> other, int bufferSize) {
        super(source);
        this.other = other;
        this.bufferSize = bufferSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Flowable<T>> s) {
        this.source.subscribe(new WindowBoundaryMainSubscriber(new SerializedSubscriber<Flowable<T>>(s), this.other, this.bufferSize));
    }

    static final class WindowBoundaryInnerSubscriber<T, B>
    extends DisposableSubscriber<B> {
        final WindowBoundaryMainSubscriber<T, B> parent;
        boolean done;

        WindowBoundaryInnerSubscriber(WindowBoundaryMainSubscriber<T, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            if (this.done) {
                return;
            }
            this.parent.next();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.onComplete();
        }
    }

    static final class WindowBoundaryMainSubscriber<T, B>
    extends QueueDrainSubscriber<T, Object, Flowable<T>>
    implements Subscription {
        final Publisher<B> other;
        final int bufferSize;
        Subscription s;
        final AtomicReference<Disposable> boundary = new AtomicReference();
        UnicastProcessor<T> window;
        static final Object NEXT = new Object();
        final AtomicLong windows = new AtomicLong();

        WindowBoundaryMainSubscriber(Subscriber<? super Flowable<T>> actual, Publisher<B> other, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.other = other;
            this.bufferSize = bufferSize;
            this.windows.lazySet(1L);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                Subscriber a = this.actual;
                a.onSubscribe(this);
                if (this.cancelled) {
                    return;
                }
                UnicastProcessor w = UnicastProcessor.create(this.bufferSize);
                long r = this.requested();
                if (r != 0L) {
                    a.onNext(w);
                    if (r != Long.MAX_VALUE) {
                        this.produced(1L);
                    }
                } else {
                    a.onError(new MissingBackpressureException("Could not deliver first window due to lack of requests"));
                    return;
                }
                this.window = w;
                WindowBoundaryInnerSubscriber inner = new WindowBoundaryInnerSubscriber(this);
                if (this.boundary.compareAndSet(null, inner)) {
                    this.windows.getAndIncrement();
                    s.request(Long.MAX_VALUE);
                    this.other.subscribe(inner);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (this.fastEnter()) {
                UnicastProcessor<T> w = this.window;
                w.onNext(t);
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            if (this.windows.decrementAndGet() == 0L) {
                DisposableHelper.dispose(this.boundary);
            }
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            if (this.windows.decrementAndGet() == 0L) {
                DisposableHelper.dispose(this.boundary);
            }
            this.actual.onComplete();
        }

        @Override
        public void request(long n) {
            this.requested(n);
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        void drainLoop() {
            SimplePlainQueue q = this.queue;
            Subscriber a = this.actual;
            int missed = 1;
            UnicastProcessor w = this.window;
            while (true) {
                boolean empty;
                boolean d = this.done;
                Object o = q.poll();
                boolean bl = empty = o == null;
                if (d && empty) {
                    DisposableHelper.dispose(this.boundary);
                    Throwable e = this.error;
                    if (e != null) {
                        w.onError(e);
                    } else {
                        w.onComplete();
                    }
                    return;
                }
                if (!empty) {
                    if (o == NEXT) {
                        w.onComplete();
                        if (this.windows.decrementAndGet() == 0L) {
                            DisposableHelper.dispose(this.boundary);
                            return;
                        }
                        if (this.cancelled) continue;
                        w = UnicastProcessor.create(this.bufferSize);
                        long r = this.requested();
                        if (r != 0L) {
                            this.windows.getAndIncrement();
                            a.onNext(w);
                            if (r != Long.MAX_VALUE) {
                                this.produced(1L);
                            }
                        } else {
                            this.cancelled = true;
                            a.onError(new MissingBackpressureException("Could not deliver new window due to lack of requests"));
                            continue;
                        }
                        this.window = w;
                        continue;
                    }
                    w.onNext(NotificationLite.getValue(o));
                    continue;
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        void next() {
            this.queue.offer(NEXT);
            if (this.enter()) {
                this.drainLoop();
            }
        }

        @Override
        public boolean accept(Subscriber<? super Flowable<T>> a, Object v) {
            return false;
        }
    }
}

