/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.Iterators;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.forgerock.util.Function;

public final class Collections2 {
    public static <M, N, E0 extends RuntimeException, E1 extends RuntimeException> Collection<N> transformedCollection(Collection<M> collection, Function<? super M, ? extends N, E0> funcMtoN, Function<? super N, ? extends M, E1> funcNtoM) {
        return new TransformedCollection<M, N, Collection<M>, E0, E1>(collection, funcMtoN, funcNtoM);
    }

    public static <M, N, E0 extends RuntimeException, E1 extends RuntimeException> List<N> transformedList(List<M> list, Function<? super M, ? extends N, E0> funcMtoN, Function<? super N, ? extends M, E1> funcNtoM) {
        return new TransformedList(list, funcMtoN, funcNtoM);
    }

    private Collections2() {
    }

    private static final class TransformedList<M, N, E0 extends RuntimeException, E1 extends RuntimeException>
    extends TransformedCollection<M, N, List<M>, E0, E1>
    implements List<N> {
        private TransformedList(List<M> list, Function<? super M, ? extends N, E0> funcMtoN, Function<? super N, ? extends M, E1> funcNtoM) {
            super(list, funcMtoN, funcNtoM);
        }

        @Override
        public void add(int index, N element) {
            ((List)this.collection).add(index, this.funcNtoM.apply(element));
        }

        @Override
        public boolean addAll(int index, Collection<? extends N> c) {
            boolean result = false;
            for (N e : c) {
                result |= this.add(e);
            }
            return result;
        }

        @Override
        public N get(int index) {
            return (N)this.funcMtoN.apply(((List)this.collection).get(index));
        }

        @Override
        public int indexOf(Object o) {
            return ((List)this.collection).indexOf(this.funcNtoM.apply(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((List)this.collection).lastIndexOf(this.funcNtoM.apply(o));
        }

        @Override
        public ListIterator<N> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<N> listIterator(int index) {
            final ListIterator iterator = ((List)this.collection).listIterator(index);
            return new ListIterator<N>(){

                @Override
                public void add(N e) {
                    iterator.add(TransformedList.this.funcNtoM.apply(e));
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return iterator.hasPrevious();
                }

                @Override
                public N next() {
                    return TransformedList.this.funcMtoN.apply(iterator.next());
                }

                @Override
                public int nextIndex() {
                    return iterator.nextIndex();
                }

                @Override
                public N previous() {
                    return TransformedList.this.funcMtoN.apply(iterator.previous());
                }

                @Override
                public int previousIndex() {
                    return iterator.previousIndex();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public void set(N e) {
                    iterator.set(TransformedList.this.funcNtoM.apply(e));
                }
            };
        }

        @Override
        public N remove(int index) {
            return (N)this.funcMtoN.apply(((List)this.collection).remove(index));
        }

        @Override
        public N set(int index, N element) {
            Object result = ((List)this.collection).set(index, this.funcNtoM.apply(element));
            return (N)this.funcMtoN.apply(result);
        }

        @Override
        public List<N> subList(int fromIndex, int toIndex) {
            List subList = ((List)this.collection).subList(fromIndex, toIndex);
            return new TransformedList(subList, this.funcMtoN, this.funcNtoM);
        }
    }

    private static class TransformedCollection<M, N, C extends Collection<M>, E0 extends RuntimeException, E1 extends RuntimeException>
    extends AbstractCollection<N>
    implements Collection<N> {
        protected final C collection;
        final Function<? super M, ? extends N, E0> funcMtoN;
        final Function<? super N, ? extends M, E1> funcNtoM;

        TransformedCollection(C collection, Function<? super M, ? extends N, E0> funcMtoN, Function<? super N, ? extends M, E1> funcNtoM) {
            this.collection = collection;
            this.funcMtoN = funcMtoN;
            this.funcNtoM = funcNtoM;
        }

        @Override
        public boolean add(N e) {
            return this.collection.add(this.funcNtoM.apply(e));
        }

        @Override
        public void clear() {
            this.collection.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.collection.contains(this.funcNtoM.apply(o));
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public Iterator<N> iterator() {
            return Iterators.transformedIterator(this.collection.iterator(), this.funcMtoN);
        }

        @Override
        public boolean remove(Object o) {
            return this.collection.remove(this.funcNtoM.apply(o));
        }

        @Override
        public int size() {
            return this.collection.size();
        }
    }
}

