/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;

final class ApplicationKeyManager
implements X509KeyManager {
    private static final LocalizedLogger LOG = LocalizedLogger.getLoggerForThisClass();
    private X509KeyManager keyManager;

    ApplicationKeyManager(KeyStore keystore, char[] password) {
        KeyManagerFactory kmf = null;
        String userSpecifiedAlgo = System.getProperty("org.opendj.admin.keymanageralgo");
        String userSpecifiedProvider = System.getProperty("org.opendj.admin.keymanagerprovider");
        String vendor = System.getProperty("java.vendor");
        if (vendor.startsWith("IBM")) {
            if (userSpecifiedAlgo == null) {
                userSpecifiedAlgo = "IbmX509";
            }
            if (userSpecifiedProvider == null) {
                userSpecifiedProvider = "IBMJSSE2";
            }
        }
        String[] preferredProvider = new String[]{userSpecifiedProvider, "SunJSSE", null, null};
        String[] preferredAlgo = new String[]{userSpecifiedAlgo, "SunX509", "SunX509", TrustManagerFactory.getDefaultAlgorithm()};
        block5: for (int i = 0; i < preferredProvider.length && this.keyManager == null; ++i) {
            String provider = preferredProvider[i];
            String algo = preferredAlgo[i];
            if (algo == null) continue;
            try {
                KeyManager[] kms;
                kmf = provider != null ? KeyManagerFactory.getInstance(algo, provider) : KeyManagerFactory.getInstance(algo);
                kmf.init(keystore, password);
                for (KeyManager km : kms = kmf.getKeyManagers()) {
                    if (!(km instanceof X509KeyManager)) continue;
                    this.keyManager = (X509KeyManager)km;
                    continue block5;
                }
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn(LocalizableMessage.raw("Error with the algorithm", e));
                continue;
            }
            catch (KeyStoreException e) {
                LOG.warn(LocalizableMessage.raw("Error with the keystore", e));
                continue;
            }
            catch (UnrecoverableKeyException e) {
                LOG.warn(LocalizableMessage.raw("Error with the key", e));
                continue;
            }
            catch (NoSuchProviderException e) {
                LOG.warn(LocalizableMessage.raw("Error with the provider", e));
            }
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.keyManager != null) {
            return this.keyManager.chooseClientAlias(keyType, issuers, socket);
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.keyManager != null) {
            return this.keyManager.chooseServerAlias(keyType, issuers, socket);
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (this.keyManager != null) {
            return this.keyManager.getCertificateChain(alias);
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (this.keyManager != null) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        if (this.keyManager != null) {
            return this.keyManager.getPrivateKey(alias);
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (this.keyManager != null) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }
        return null;
    }
}

