/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class BooleanSyntaxImpl
extends AbstractSyntaxImpl {
    BooleanSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.13";
    }

    @Override
    public String getName() {
        return "Boolean";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueString = value.toString();
        String valueUpperCase = valueString.toUpperCase();
        if (!("TRUE".equals(valueUpperCase) || "YES".equals(valueUpperCase) || "ON".equals(valueUpperCase) || "1".equals(valueUpperCase) || "FALSE".equals(valueUpperCase) || "NO".equals(valueUpperCase) || "OFF".equals(valueUpperCase) || "0".equals(valueUpperCase))) {
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get(valueString));
            return false;
        }
        return true;
    }
}

