/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import java.util.Collections;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;

abstract class AbstractOrderingMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    private final Indexer indexer;

    AbstractOrderingMatchingRuleImpl(String indexId) {
        this.indexer = new AbstractMatchingRuleImpl.DefaultIndexer(indexId);
    }

    @Override
    public final Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
        final ByteString normAssertion = this.normalizeAttributeValue(schema, value);
        return new Assertion(){

            @Override
            public ConditionResult matches(ByteSequence attributeValue) {
                return ConditionResult.valueOf(attributeValue.compareTo(normAssertion) < 0);
            }

            @Override
            public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                return factory.createRangeMatchQuery(AbstractOrderingMatchingRuleImpl.this.indexer.getIndexId(), ByteString.empty(), normAssertion, false, false);
            }
        };
    }

    @Override
    public final Assertion getGreaterOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        final ByteString normAssertion = this.normalizeAttributeValue(schema, value);
        return new Assertion(){

            @Override
            public ConditionResult matches(ByteSequence normalizedAttributeValue) {
                return ConditionResult.valueOf(normalizedAttributeValue.compareTo(normAssertion) >= 0);
            }

            @Override
            public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                return factory.createRangeMatchQuery(AbstractOrderingMatchingRuleImpl.this.indexer.getIndexId(), normAssertion, ByteString.empty(), true, false);
            }
        };
    }

    @Override
    public final Assertion getLessOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        final ByteString normAssertion = this.normalizeAttributeValue(schema, value);
        return new Assertion(){

            @Override
            public ConditionResult matches(ByteSequence normalizedAttributeValue) {
                return ConditionResult.valueOf(normalizedAttributeValue.compareTo(normAssertion) <= 0);
            }

            @Override
            public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                return factory.createRangeMatchQuery(AbstractOrderingMatchingRuleImpl.this.indexer.getIndexId(), ByteString.empty(), normAssertion, false, true);
            }
        };
    }

    @Override
    public final Collection<? extends Indexer> createIndexers(IndexingOptions options) {
        return Collections.singleton(this.indexer);
    }
}

