/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResult;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.GenericExtendedResult;

final class GenericExtendedResultImpl
extends AbstractExtendedResult<GenericExtendedResult>
implements ExtendedResult,
GenericExtendedResult {
    private String responseName;
    private ByteString responseValue;

    GenericExtendedResultImpl(GenericExtendedResult genericExtendedResult) {
        super(genericExtendedResult);
        this.responseName = genericExtendedResult.getOid();
        this.responseValue = genericExtendedResult.getValue();
    }

    GenericExtendedResultImpl(ResultCode resultCode) {
        super(resultCode);
    }

    @Override
    public String getOid() {
        return this.responseName;
    }

    @Override
    public ByteString getValue() {
        return this.responseValue;
    }

    @Override
    public boolean hasValue() {
        return this.responseValue != null;
    }

    @Override
    public GenericExtendedResult setOid(String oid) {
        this.responseName = oid;
        return this;
    }

    @Override
    public GenericExtendedResult setValue(Object value) {
        this.responseValue = value != null ? ByteString.valueOfObject(value) : null;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GenericExtendedResult(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDn=");
        builder.append(this.getMatchedDn());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralUris());
        builder.append(", responseName=");
        builder.append(this.getOid() == null ? "" : this.getOid());
        if (this.hasValue()) {
            builder.append(", responseValue=");
            builder.append(this.getValue().toHexPlusAsciiString(4));
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

