/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Request;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.http.HttpUtils;
import org.forgerock.services.context.AbstractContext;
import org.forgerock.services.context.Context;
import org.forgerock.util.LazyMap;

public final class HttpContext
extends AbstractContext {
    public static final String ATTR_HEADERS = "headers";
    public static final String ATTR_PARAMETERS = "parameters";
    public static final String ATTR_METHOD = "method";
    public static final String ATTR_PATH = "path";
    private final Map<String, List<String>> headers;
    private final Map<String, List<String>> parameters;

    HttpContext(Context parent, Request req) {
        super(parent, "http");
        this.data.put(ATTR_METHOD, (Object)HttpUtils.getMethod(req));
        this.data.put(ATTR_PATH, (Object)this.getRequestPath(req));
        this.headers = Collections.unmodifiableMap(new LazyMap(() -> {
            TreeMap<String, List<String>> result = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, Header> header : req.getHeaders().asMapOfHeaders().entrySet()) {
                String name = header.getKey();
                List<String> values = header.getValue().getValues();
                result.put(name, values);
            }
            return result;
        }));
        this.data.put(ATTR_HEADERS, this.headers);
        this.parameters = Collections.unmodifiableMap(new LazyMap(() -> {
            LinkedHashMap<String, List> result = new LinkedHashMap<String, List>();
            Set parameters = req.getForm().entrySet();
            for (Map.Entry parameter : parameters) {
                String name = (String)parameter.getKey();
                List values = (List)parameter.getValue();
                result.put(name, values);
            }
            return result;
        }));
        this.data.put(ATTR_PARAMETERS, this.parameters);
    }

    public HttpContext(JsonValue savedContext, ClassLoader classLoader) {
        super(savedContext, classLoader);
        this.headers = this.data.get(ATTR_HEADERS).required().asMapOfList(String.class);
        this.parameters = this.data.get(ATTR_PARAMETERS).required().asMapOfList(String.class);
    }

    private String getRequestPath(Request req) {
        return req.getUri().getScheme() + "://" + req.getUri().getRawAuthority() + req.getUri().getRawPath();
    }

    public List<String> getHeader(String name) {
        List<String> header = this.headers.get(name);
        return Collections.unmodifiableList(header != null ? header : Collections.emptyList());
    }

    public String getHeaderAsString(String name) {
        List<String> header = this.getHeader(name);
        return header.isEmpty() ? null : header.get(0);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.data.get(ATTR_METHOD).asString();
    }

    public List<String> getParameter(String name) {
        List<String> parameter = this.parameters.get(name);
        return Collections.unmodifiableList(parameter != null ? parameter : Collections.emptyList());
    }

    public String getParameterAsString(String name) {
        List<String> parameter = this.getParameter(name);
        return parameter.isEmpty() ? null : parameter.get(0);
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public String getPath() {
        return this.data.get(ATTR_PATH).asString();
    }
}

