/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class SimpleHTTPClient {
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private final int readTimeout;
    private final int connTimeout;

    public SimpleHTTPClient() {
        this(5000, 5000);
    }

    public SimpleHTTPClient(int readTimeout, int connTimeout) {
        if (readTimeout < 0 || connTimeout < 0) {
            throw new IllegalArgumentException("Unable to set the read or connection timeouts to a value less than zero");
        }
        this.readTimeout = readTimeout;
        this.connTimeout = connTimeout;
    }

    public String get(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (this.readTimeout >= 0) {
            conn.setReadTimeout(this.readTimeout);
        } else {
            conn.setReadTimeout(5000);
        }
        if (this.connTimeout >= 0) {
            conn.setConnectTimeout(this.connTimeout);
        } else {
            conn.setConnectTimeout(5000);
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String input;
            while ((input = reader.readLine()) != null) {
                sb.append(input);
            }
        }
        return sb.toString();
    }
}

