/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.MemoryBackend;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldif.Ldif;
import org.forgerock.opendj.ldif.LdifEntryReader;
import org.forgerock.opendj.ldif.LdifEntryWriter;
import org.forgerock.opendj.security.KeyStoreImpl;
import org.forgerock.opendj.security.KeyStoreObject;
import org.forgerock.opendj.security.KeyStoreObjectCache;
import org.forgerock.opendj.security.KeyStoreParameters;
import org.forgerock.opendj.security.OpenDjSecurityProviderSchema;
import org.forgerock.util.Factory;
import org.forgerock.util.Options;

public final class OpenDjSecurityProvider
extends Provider {
    private static final long serialVersionUID = -1L;
    private static final String PREFIX = "org.forgerock.opendj.security.";
    private static final String LDIF_PROPERTY = "org.forgerock.opendj.security.ldif";
    private static final String HOST_PROPERTY = "org.forgerock.opendj.security.host";
    private static final String PORT_PROPERTY = "org.forgerock.opendj.security.port";
    private static final String BIND_DN_PROPERTY = "org.forgerock.opendj.security.bindDn";
    private static final String BIND_PASSWORD_PROPERTY = "org.forgerock.opendj.security.bindPassword";
    private static final String KEYSTORE_BASE_DN_PROPERTY = "org.forgerock.opendj.security.keyStoreBaseDn";
    private static final String KEYSTORE_PASSWORD_PROPERTY = "org.forgerock.opendj.security.keyStorePassword";
    private final KeyStoreParameters defaultConfig;

    public OpenDjSecurityProvider() {
        this((KeyStoreParameters)null);
    }

    public OpenDjSecurityProvider(String configFile) {
        this(new File(configFile).toURI());
    }

    public OpenDjSecurityProvider(URI configFile) {
        this(configFile != null ? OpenDjSecurityProvider.parseConfig(configFile) : null);
    }

    OpenDjSecurityProvider(KeyStoreParameters defaultConfig) {
        super("OpenDJ", 1.0, "OpenDJ LDAP security provider");
        this.defaultConfig = defaultConfig;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                OpenDjSecurityProvider.this.putService(new KeyStoreService());
                return null;
            }
        });
    }

    public static KeyStore newLdapKeyStore(ConnectionFactory factory, Dn baseDN) {
        return OpenDjSecurityProvider.newLdapKeyStore(factory, baseDN, Options.defaultOptions());
    }

    public static KeyStore newLdapKeyStore(ConnectionFactory factory, Dn baseDN, Options options) {
        try {
            KeyStore keyStore = KeyStore.getInstance("LDAP", new OpenDjSecurityProvider());
            keyStore.load(KeyStoreParameters.newKeyStoreParameters(factory, baseDN, options));
            return keyStore;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore newLdifKeyStore(File ldifFile, Dn baseDN) throws IOException {
        return OpenDjSecurityProvider.newLdifKeyStore(ldifFile, baseDN, Options.defaultOptions());
    }

    public static KeyStore newLdifKeyStore(File ldifFile, Dn baseDN, Options options) throws IOException {
        return OpenDjSecurityProvider.newLdapKeyStore(OpenDjSecurityProvider.newLdifConnectionFactory(ldifFile), baseDN, options);
    }

    private static ConnectionFactory newLdifConnectionFactory(File ldifFile) throws IOException {
        try (LdifEntryReader reader = new LdifEntryReader(new FileReader(ldifFile)).setSchema(OpenDjSecurityProviderSchema.SCHEMA);){
            MemoryBackend backend = new MemoryBackend(OpenDjSecurityProviderSchema.SCHEMA, reader).enableVirtualAttributes(true);
            ConnectionFactory connectionFactory = Connections.newInternalConnectionFactory(new WriteLdifOnUpdateRequestHandler(backend, ldifFile));
            return connectionFactory;
        }
    }

    public static KeyStoreObjectCache newKeyStoreObjectCacheFromMap(final Map<String, KeyStoreObject> map) {
        return new KeyStoreObjectCache(){

            @Override
            public void put(KeyStoreObject keyStoreObject) {
                map.put(keyStoreObject.getAlias(), keyStoreObject);
            }

            @Override
            public KeyStoreObject get(String alias) {
                return (KeyStoreObject)map.get(alias);
            }
        };
    }

    public static KeyStoreObjectCache newCapacityBasedKeyStoreObjectCache(final int capacity) {
        return OpenDjSecurityProvider.newKeyStoreObjectCacheFromMap(Collections.synchronizedMap(new LinkedHashMap<String, KeyStoreObject>(){
            private static final long serialVersionUID = -1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, KeyStoreObject> eldest) {
                return this.size() > capacity;
            }
        }));
    }

    public static Factory<char[]> newClearTextPasswordFactory(final char[] password) {
        return new Factory<char[]>(){
            private final char[] clonedPassword;
            {
                this.clonedPassword = password != null ? (char[])password.clone() : null;
            }

            @Override
            public char[] newInstance() {
                return this.clonedPassword != null ? (char[])this.clonedPassword.clone() : null;
            }
        };
    }

    KeyStoreParameters getDefaultConfig() {
        return this.defaultConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStoreParameters parseConfig(URI configFile) {
        try (InputStreamReader configFileReader = new InputStreamReader(configFile.toURL().openStream());){
            ConnectionFactory factory;
            String ldif;
            Properties properties = new Properties();
            properties.load(configFileReader);
            String keyStoreBaseDNProperty = properties.getProperty(KEYSTORE_BASE_DN_PROPERTY);
            if (keyStoreBaseDNProperty == null) {
                throw new IllegalArgumentException("missing key store base DN");
            }
            Dn keyStoreBaseDN = Dn.valueOf(keyStoreBaseDNProperty);
            Options keystoreOptions = Options.defaultOptions();
            String keystorePassword = properties.getProperty(KEYSTORE_PASSWORD_PROPERTY);
            if (keystorePassword != null) {
                keystoreOptions.set(KeyStoreParameters.GLOBAL_PASSWORD, OpenDjSecurityProvider.newClearTextPasswordFactory(keystorePassword.toCharArray()));
            }
            if ((ldif = properties.getProperty(LDIF_PROPERTY)) != null) {
                factory = OpenDjSecurityProvider.newLdifConnectionFactory(new File(ldif));
            } else {
                String host = properties.getProperty(HOST_PROPERTY, "localhost");
                int port = Integer.parseInt(properties.getProperty(PORT_PROPERTY, "389"));
                Dn bindDN = Dn.valueOf(properties.getProperty(BIND_DN_PROPERTY, ""));
                String bindPassword = properties.getProperty(BIND_PASSWORD_PROPERTY);
                Options factoryOptions = Options.defaultOptions();
                if (!bindDN.isRootDn()) {
                    factoryOptions.set(LdapConnectionFactory.AUTHN_BIND_REQUEST, Requests.newSimpleBindRequest(bindDN, bindPassword));
                }
                factory = Connections.newCachedConnectionPool(new LdapConnectionFactory(host, port, factoryOptions));
            }
            KeyStoreParameters keyStoreParameters = KeyStoreParameters.newKeyStoreParameters(factory, keyStoreBaseDN, keystoreOptions);
            return keyStoreParameters;
        }
        catch (Exception e) {
            throw new ProviderException("Error parsing configuration in file '" + configFile + "'", e);
        }
    }

    private final class KeyStoreService
    extends Provider.Service {
        private KeyStoreService() {
            super(OpenDjSecurityProvider.this, "KeyStore", "LDAP", KeyStoreImpl.class.getName(), Collections.singletonList("OpenDJ"), null);
        }

        @Override
        public Object newInstance(Object constructorParameter) {
            return new KeyStoreImpl(OpenDjSecurityProvider.this);
        }
    }

    private static final class WriteLdifOnUpdateRequestHandler
    implements RequestHandler<RequestContext> {
        private final MemoryBackend backend;
        private final File ldifFile;

        private WriteLdifOnUpdateRequestHandler(MemoryBackend backend, File ldifFile) {
            this.backend = backend;
            this.ldifFile = ldifFile;
        }

        @Override
        public void handleAdd(RequestContext requestContext, AddRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleAdd(requestContext, request, intermediateResponseHandler, this.saveAndForwardTo(resultHandler));
        }

        @Override
        public void handleBind(RequestContext requestContext, BindRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<BindResult> resultHandler) {
            this.backend.handleBind(requestContext, request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleCompare(RequestContext requestContext, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<CompareResult> resultHandler) {
            this.backend.handleCompare(requestContext, request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleDelete(RequestContext requestContext, DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleDelete(requestContext, request, intermediateResponseHandler, this.saveAndForwardTo(resultHandler));
        }

        @Override
        public <R extends ExtendedResult> void handleExtendedRequest(RequestContext requestContext, ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<R> resultHandler) {
            this.backend.handleExtendedRequest(requestContext, request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleModify(RequestContext requestContext, ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleModify(requestContext, request, intermediateResponseHandler, this.saveAndForwardTo(resultHandler));
        }

        @Override
        public void handleModifyDn(RequestContext requestContext, ModifyDnRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleModifyDn(requestContext, request, intermediateResponseHandler, this.saveAndForwardTo(resultHandler));
        }

        @Override
        public void handleSearch(RequestContext requestContext, SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleSearch(requestContext, request, intermediateResponseHandler, entryHandler, resultHandler);
        }

        private LdapResultHandler<Result> saveAndForwardTo(final LdapResultHandler<Result> resultHandler) {
            return new LdapResultHandler<Result>(){

                @Override
                public void handleException(LdapException exception) {
                    resultHandler.handleException(exception);
                }

                @Override
                public void handleResult(Result result) {
                    try {
                        WriteLdifOnUpdateRequestHandler.writeLdif(WriteLdifOnUpdateRequestHandler.this.backend, WriteLdifOnUpdateRequestHandler.this.ldifFile);
                        resultHandler.handleResult(result);
                    }
                    catch (IOException e) {
                        LdapException ldapException = LdapException.newLdapException(ResultCode.OTHER, "Unable to write LDIF file " + WriteLdifOnUpdateRequestHandler.this.ldifFile, e);
                        resultHandler.handleException(ldapException);
                    }
                }
            };
        }

        private static void writeLdif(MemoryBackend backend, File ldifFile) throws IOException {
            try (FileWriter fileWriter = new FileWriter(ldifFile);
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                 LdifEntryWriter entryWriter = new LdifEntryWriter(bufferedWriter);){
                Ldif.copyTo(Ldif.newEntryIteratorReader(backend.getAll().iterator()), entryWriter);
            }
        }
    }
}

