/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import org.forgerock.http.protocol.Headers;
import org.forgerock.util.Function;
import org.forgerock.util.Pair;
import org.forgerock.util.Reject;
import org.forgerock.util.encode.Base64;
import org.forgerock.util.promise.NeverThrowsException;

public final class CredentialExtractors {
    static final String HTTP_BASIC_AUTH_HEADER = "Authorization";

    private CredentialExtractors() {
    }

    public static Function<Headers, Pair<String, String>, NeverThrowsException> httpBasicExtractor() {
        return HttpBasicExtractor.INSTANCE;
    }

    public static Function<Headers, Pair<String, String>, NeverThrowsException> newCustomHeaderExtractor(String customHeaderUsername, String customHeaderPassword) {
        return new CustomHeaderExtractor(customHeaderUsername, customHeaderPassword);
    }

    private static final class HttpBasicExtractor
    implements Function<Headers, Pair<String, String>, NeverThrowsException> {
        public static final HttpBasicExtractor INSTANCE = new HttpBasicExtractor();

        private HttpBasicExtractor() {
        }

        @Override
        public Pair<String, String> apply(Headers headers) {
            Pair<String, String> userCredentials;
            String httpBasicAuthHeader = headers.getFirst(CredentialExtractors.HTTP_BASIC_AUTH_HEADER);
            if (httpBasicAuthHeader != null && (userCredentials = this.parseUsernamePassword(httpBasicAuthHeader)) != null) {
                return userCredentials;
            }
            return null;
        }

        private Pair<String, String> parseUsernamePassword(String authHeader) {
            String base64UserCredentials;
            String userCredentials;
            String[] split;
            if (authHeader != null && authHeader.toLowerCase().startsWith("basic") && (split = (userCredentials = new String(Base64.decode(base64UserCredentials = authHeader.substring("basic".length() + 1)))).split(":")).length == 2) {
                return Pair.of(split[0], split[1]);
            }
            return null;
        }
    }

    private static final class CustomHeaderExtractor
    implements Function<Headers, Pair<String, String>, NeverThrowsException> {
        private final String customHeaderUsername;
        private final String customHeaderPassword;

        CustomHeaderExtractor(String customHeaderUsername, String customHeaderPassword) {
            this.customHeaderUsername = Reject.checkNotNull(customHeaderUsername, "customHeaderUsername cannot be null");
            this.customHeaderPassword = Reject.checkNotNull(customHeaderPassword, "customHeaderPassword cannot be null");
        }

        @Override
        public Pair<String, String> apply(Headers headers) {
            String userName = headers.getFirst(this.customHeaderUsername);
            String password = headers.getFirst(this.customHeaderPassword);
            if (userName != null && password != null) {
                return Pair.of(userName, password);
            }
            return HttpBasicExtractor.INSTANCE.apply(headers);
        }
    }
}

