/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class DitContentRule
extends AbstractSchemaElement {
    private final String structuralClassOid;
    private final List<String> names;
    private final boolean isObsolete;
    private final Set<String> auxiliaryClassOids;
    private final Set<String> optionalAttributeOids;
    private final Set<String> prohibitedAttributeOids;
    private final Set<String> requiredAttributeOids;
    private ObjectClass structuralClass;
    private Set<ObjectClass> auxiliaryClasses = Collections.emptySet();
    private Set<AttributeType> optionalAttributes = Collections.emptySet();
    private Set<AttributeType> prohibitedAttributes = Collections.emptySet();
    private Set<AttributeType> requiredAttributes = Collections.emptySet();

    private DitContentRule(Builder builder) {
        super(builder);
        Reject.ifNull(builder.structuralClassOid);
        this.structuralClassOid = builder.structuralClassOid;
        this.names = SchemaUtils.unmodifiableCopyOfList(builder.names);
        this.isObsolete = builder.isObsolete;
        this.auxiliaryClassOids = SchemaUtils.unmodifiableCopyOfSet(builder.auxiliaryClassOids);
        this.optionalAttributeOids = SchemaUtils.unmodifiableCopyOfSet(builder.optionalAttributeOids);
        this.prohibitedAttributeOids = SchemaUtils.unmodifiableCopyOfSet(builder.prohibitedAttributeOids);
        this.requiredAttributeOids = SchemaUtils.unmodifiableCopyOfSet(builder.requiredAttributeOids);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DitContentRule) {
            DitContentRule other = (DitContentRule)o;
            return this.structuralClassOid.equals(other.structuralClassOid);
        }
        return false;
    }

    public Set<ObjectClass> getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    public String getNameOrOid() {
        if (this.names.isEmpty()) {
            return this.structuralClassOid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public Set<AttributeType> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<AttributeType> getProhibitedAttributes() {
        return this.prohibitedAttributes;
    }

    public Set<AttributeType> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public ObjectClass getStructuralClass() {
        return this.structuralClass;
    }

    public String getStructuralClassOid() {
        return this.structuralClassOid;
    }

    @Override
    public int hashCode() {
        return this.structuralClassOid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOid(String value) {
        return this.hasName(value) || this.structuralClassOid.equals(value);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public boolean isOptional(AttributeType attributeType) {
        return this.optionalAttributes.contains(attributeType);
    }

    public boolean isRequired(AttributeType attributeType) {
        return this.requiredAttributes.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        return this.isRequired(attributeType) || this.isOptional(attributeType);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.structuralClassOid);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        this.appendDescription(buffer);
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (!this.auxiliaryClassOids.isEmpty()) {
            iterator = this.auxiliaryClassOids.iterator();
            String firstClass = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" AUX (");
                buffer.append(firstClass);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" AUX ");
                buffer.append(firstClass);
            }
        }
        if (!this.requiredAttributeOids.isEmpty()) {
            iterator = this.requiredAttributeOids.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MUST ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MUST ");
                buffer.append(firstName);
            }
        }
        if (!this.optionalAttributeOids.isEmpty()) {
            iterator = this.optionalAttributeOids.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MAY ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MAY ");
                buffer.append(firstName);
            }
        }
        if (!this.prohibitedAttributeOids.isEmpty()) {
            iterator = this.prohibitedAttributeOids.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NOT ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" NOT ");
                buffer.append(firstName);
            }
        }
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        if (this.structuralClassOid != null) {
            try {
                this.structuralClass = schema.getObjectClass(this.structuralClassOid);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_STRUCTURAL_CLASS1.get(this.getNameOrOid(), this.structuralClassOid);
                throw new SchemaException(message, (Throwable)e);
            }
            if (this.structuralClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_STRUCTURAL_CLASS_NOT_STRUCTURAL1.get(this.getNameOrOid(), this.structuralClass.getNameOrOid(), (Object)this.structuralClass.getObjectClassType());
                warnings.add(message);
            }
            if (!this.isObsolete() && this.structuralClass.isObsolete()) {
                warnings.add(CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_STRUCTURAL_CLASS.get(this.getNameOrOid(), this.structuralClassOid));
            }
        }
        if (!this.auxiliaryClassOids.isEmpty()) {
            this.auxiliaryClasses = new HashSet<ObjectClass>(this.auxiliaryClassOids.size());
            for (String oid : this.auxiliaryClassOids) {
                ObjectClass objectClass;
                try {
                    objectClass = schema.getObjectClass(oid);
                }
                catch (UnknownSchemaElementException e) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_AUXILIARY_CLASS1.get(this.getNameOrOid(), oid);
                    throw new SchemaException(message, (Throwable)e);
                }
                if (objectClass.getObjectClassType() != ObjectClassType.AUXILIARY) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_AUXILIARY_CLASS_NOT_AUXILIARY1.get(this.getNameOrOid(), this.structuralClass.getOid(), (Object)this.structuralClass.getObjectClassType());
                    throw new SchemaException(message);
                }
                if (!this.isObsolete() && objectClass.isObsolete()) {
                    warnings.add(CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_AUXILIARY_CLASS.get(this.getNameOrOid(), oid));
                }
                this.auxiliaryClasses.add(objectClass);
            }
        }
        if (!this.requiredAttributeOids.isEmpty()) {
            this.requiredAttributes = this.getAttributeTypes(schema, this.requiredAttributeOids, CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_REQUIRED_ATTR1, warnings, CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_REQUIRED_ATTR);
        }
        if (!this.optionalAttributeOids.isEmpty()) {
            this.optionalAttributes = this.getAttributeTypes(schema, this.optionalAttributeOids, CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_OPTIONAL_ATTR1, warnings, CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_OPTIONAL_ATTR);
        }
        if (!this.prohibitedAttributeOids.isEmpty()) {
            this.prohibitedAttributes = this.getAttributeTypes(schema, this.prohibitedAttributeOids, CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_PROHIBITED_ATTR1, warnings, CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_PROHIBITED_ATTR);
        }
        for (AttributeType t : this.prohibitedAttributes) {
            if (this.structuralClass.isRequired(t)) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_STRUCTURAL.get(this.getNameOrOid(), t.getNameOrOid(), this.structuralClass.getNameOrOid());
                throw new SchemaException(message);
            }
            for (ObjectClass oc : this.auxiliaryClasses) {
                if (!oc.isRequired(t)) continue;
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_AUXILIARY.get(this.getNameOrOid(), t.getNameOrOid(), oc.getNameOrOid());
                throw new SchemaException(message);
            }
        }
        this.auxiliaryClasses = Collections.unmodifiableSet(this.auxiliaryClasses);
        this.optionalAttributes = Collections.unmodifiableSet(this.optionalAttributes);
        this.prohibitedAttributes = Collections.unmodifiableSet(this.prohibitedAttributes);
        this.requiredAttributes = Collections.unmodifiableSet(this.requiredAttributes);
    }

    private Set<AttributeType> getAttributeTypes(Schema schema, Set<String> oids, LocalizableMessageDescriptor.Arg2<Object, Object> unkwownElementErrorMsg, List<LocalizableMessage> warnings, LocalizableMessageDescriptor.Arg2<Object, Object> obsoleteElementWarningMsg) throws SchemaException {
        HashSet<AttributeType> attrTypes = new HashSet<AttributeType>(oids.size());
        for (String oid : oids) {
            AttributeType attributeType;
            try {
                attributeType = schema.getAttributeType(oid);
                attrTypes.add(attributeType);
            }
            catch (UnknownSchemaElementException e) {
                throw new SchemaException(unkwownElementErrorMsg.get(this.getNameOrOid(), oid), (Throwable)e);
            }
            if (this.isObsolete() || !attributeType.isObsolete()) continue;
            warnings.add(obsoleteElementWarningMsg.get(this.getNameOrOid(), oid));
        }
        return attrTypes;
    }

    public static final class Builder
    extends AbstractSchemaElement.SchemaElementBuilder<Builder> {
        private String structuralClassOid;
        private final List<String> names = new LinkedList<String>();
        private boolean isObsolete;
        private final Set<String> auxiliaryClassOids = new LinkedHashSet<String>();
        private final Set<String> optionalAttributeOids = new LinkedHashSet<String>();
        private final Set<String> prohibitedAttributeOids = new LinkedHashSet<String>();
        private final Set<String> requiredAttributeOids = new LinkedHashSet<String>();

        Builder(DitContentRule contentRule, SchemaBuilder schemaBuilder) {
            super(schemaBuilder, contentRule);
            this.structuralClassOid = contentRule.structuralClassOid;
            this.names.addAll(contentRule.getNames());
            this.isObsolete = contentRule.isObsolete;
            this.auxiliaryClassOids.addAll(contentRule.auxiliaryClassOids);
            this.optionalAttributeOids.addAll(contentRule.optionalAttributeOids);
            this.prohibitedAttributeOids.addAll(contentRule.prohibitedAttributeOids);
            this.requiredAttributeOids.addAll(contentRule.requiredAttributeOids);
        }

        Builder(String structuralClassOid, SchemaBuilder builder) {
            super(builder);
            this.structuralClassOid = structuralClassOid;
        }

        public SchemaBuilder addToSchema() {
            return this.getSchemaBuilder().addDitContentRule(new DitContentRule(this), false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.getSchemaBuilder().addDitContentRule(new DitContentRule(this), true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            return overwrite ? this.addToSchemaOverwrite() : this.addToSchema();
        }

        public Builder auxiliaryObjectClasses(Collection<String> objectClassNamesOrOids) {
            this.auxiliaryClassOids.addAll(objectClassNamesOrOids);
            return this;
        }

        public Builder auxiliaryObjectClasses(String ... objectClassNamesOrOids) {
            this.auxiliaryClassOids.addAll(Arrays.asList(objectClassNamesOrOids));
            return this;
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public Builder names(Collection<String> names) {
            this.names.addAll(names);
            return this;
        }

        public Builder names(String ... names) {
            return this.names(Arrays.asList(names));
        }

        public Builder obsolete(boolean isObsolete) {
            this.isObsolete = isObsolete;
            return this;
        }

        public Builder optionalAttributes(Collection<String> attributeNamesOrOids) {
            this.optionalAttributeOids.addAll(attributeNamesOrOids);
            return this;
        }

        public Builder optionalAttributes(String ... attributeNamesOrOids) {
            this.optionalAttributeOids.addAll(Arrays.asList(attributeNamesOrOids));
            return this;
        }

        public Builder prohibitedAttributes(Collection<String> attributeNamesOrOids) {
            this.prohibitedAttributeOids.addAll(attributeNamesOrOids);
            return this;
        }

        public Builder prohibitedAttributes(String ... attributeNamesOrOids) {
            this.prohibitedAttributeOids.addAll(Arrays.asList(attributeNamesOrOids));
            return this;
        }

        public Builder removeAllAuxiliaryObjectClasses() {
            this.auxiliaryClassOids.clear();
            return this;
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        public Builder removeAllNames() {
            this.names.clear();
            return this;
        }

        public Builder removeAllOptionalAttributes() {
            this.optionalAttributeOids.clear();
            return this;
        }

        public Builder removeAllProhibitedAttributes() {
            this.prohibitedAttributeOids.clear();
            return this;
        }

        public Builder removeAllRequiredAttributes() {
            this.requiredAttributeOids.clear();
            return this;
        }

        public Builder removeAuxiliaryObjectClass(String objectClassNameOrOid) {
            this.auxiliaryClassOids.remove(objectClassNameOrOid);
            return this;
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder removeName(String name) {
            this.names.remove(name);
            return this;
        }

        public Builder removeOptionalAttribute(String attributeNameOrOid) {
            this.optionalAttributeOids.remove(attributeNameOrOid);
            return this;
        }

        public Builder removeProhibitedAttribute(String attributeNameOrOid) {
            this.prohibitedAttributeOids.remove(attributeNameOrOid);
            return this;
        }

        public Builder removeRequiredAttribute(String attributeNameOrOid) {
            this.requiredAttributeOids.remove(attributeNameOrOid);
            return this;
        }

        public Builder requiredAttributes(Collection<String> attributeNamesOrOids) {
            this.requiredAttributeOids.addAll(attributeNamesOrOids);
            return this;
        }

        public Builder requiredAttributes(String ... attributeNamesOrOids) {
            this.requiredAttributeOids.addAll(Arrays.asList(attributeNamesOrOids));
            return this;
        }

        public Builder structuralClassOid(String structuralClassOid) {
            this.structuralClassOid = structuralClassOid;
            return this;
        }
    }
}

