/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.messages.ProtocolOp;
import org.forgerock.util.Reject;

abstract class AbstractProtocolOpImpl<M extends ProtocolOp>
implements ProtocolOp {
    private final List<Control> controls = new LinkedList<Control>();

    public static Control getControl(List<Control> controls, String oid) {
        if (!controls.isEmpty()) {
            for (Control control : controls) {
                if (!control.getOid().equals(oid)) continue;
                return control;
            }
        }
        return null;
    }

    AbstractProtocolOpImpl() {
    }

    AbstractProtocolOpImpl(ProtocolOp protocolOp) {
        Reject.ifNull(protocolOp);
        for (Control control : protocolOp.getControls()) {
            this.controls.add(GenericControl.newControl(control));
        }
    }

    public final M addControl(Control control) {
        Reject.ifNull(control);
        this.controls.add(control);
        return this.getThis();
    }

    @Override
    public final boolean containsControl(String oid) {
        return AbstractProtocolOpImpl.getControl(this.controls, oid) != null;
    }

    @Override
    public final <C extends Control> C getControl(ControlDecoder<C> decoder, DecodeOptions options) throws DecodeException {
        Reject.ifNull(decoder, options);
        Control control = AbstractProtocolOpImpl.getControl(this.controls, decoder.getOid());
        return control != null ? (C)decoder.decodeControl(control, options) : null;
    }

    @Override
    public final List<Control> getControls() {
        return this.controls;
    }

    public abstract String toString();

    abstract M getThis();
}

