/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.controls.PasswordPolicyErrorType;
import org.forgerock.opendj.ldap.controls.PasswordPolicyWarningType;
import org.forgerock.util.Reject;

public final class PasswordPolicyResponseControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "1.3.6.1.4.1.42.2.27.8.5.1";
    private final int warningValue;
    private final PasswordPolicyErrorType errorType;
    private final PasswordPolicyWarningType warningType;
    public static final ControlDecoder<PasswordPolicyResponseControl> DECODER = new ControlDecoder<PasswordPolicyResponseControl>(){

        @Override
        public PasswordPolicyResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof PasswordPolicyResponseControl) {
                return (PasswordPolicyResponseControl)control;
            }
            if (!control.getOid().equals(PasswordPolicyResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PWPOLICYRES_CONTROL_BAD_OID.get(control.getOid(), PasswordPolicyResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PWPOLICYRES_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            Asn1Reader reader = Asn1.getReader(control.getValue());
            try {
                PasswordPolicyWarningType warningType = null;
                PasswordPolicyErrorType errorType = null;
                int warningValue = -1;
                reader.readStartSequence();
                if (reader.hasNextElement() && reader.peekType() == -96) {
                    reader.readStartSequence();
                    int warningChoiceValue = 0x7F & reader.peekType();
                    if (warningChoiceValue < 0 || warningChoiceValue >= PasswordPolicyWarningType.values().length) {
                        LocalizableMessage message = CoreMessages.ERR_PWPOLICYRES_INVALID_WARNING_TYPE.get(StaticUtils.byteToHex(reader.peekType()));
                        throw DecodeException.error(message);
                    }
                    warningType = PasswordPolicyWarningType.values()[warningChoiceValue];
                    warningValue = (int)reader.readInteger();
                    reader.readEndSequence();
                }
                if (reader.hasNextElement() && reader.peekType() == -127) {
                    int errorValue = reader.readEnumerated();
                    if (errorValue < 0 || errorValue >= PasswordPolicyErrorType.values().length) {
                        LocalizableMessage message = CoreMessages.ERR_PWPOLICYRES_INVALID_ERROR_TYPE.get(errorValue);
                        throw DecodeException.error(message);
                    }
                    errorType = PasswordPolicyErrorType.values()[errorValue];
                }
                reader.readEndSequence();
                return new PasswordPolicyResponseControl(control.isCritical(), warningType, warningValue, errorType);
            }
            catch (IOException e) {
                logger.debug(LocalizableMessage.raw("%s", e));
                LocalizableMessage message = CoreMessages.ERR_PWPOLICYRES_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message);
            }
        }

        @Override
        public String getOid() {
            return PasswordPolicyResponseControl.OID;
        }
    };
    private final boolean isCritical;
    private static final byte TYPE_WARNING_ELEMENT = -96;
    private static final byte TYPE_ERROR_ELEMENT = -127;

    public static PasswordPolicyResponseControl newControl(PasswordPolicyErrorType errorType) {
        Reject.ifNull((Object)errorType);
        return new PasswordPolicyResponseControl(false, null, -1, errorType);
    }

    public static PasswordPolicyResponseControl newControl(PasswordPolicyWarningType warningType, int warningValue) {
        Reject.ifNull((Object)warningType);
        Reject.ifFalse(warningValue >= 0, "warningValue is negative");
        return new PasswordPolicyResponseControl(false, warningType, warningValue, null);
    }

    public static PasswordPolicyResponseControl newControl(PasswordPolicyWarningType warningType, int warningValue, PasswordPolicyErrorType errorType) {
        Reject.ifNull((Object)warningType);
        Reject.ifNull((Object)errorType);
        Reject.ifFalse(warningValue >= 0, "warningValue is negative");
        return new PasswordPolicyResponseControl(false, warningType, warningValue, errorType);
    }

    private PasswordPolicyResponseControl(boolean isCritical, PasswordPolicyWarningType warningType, int warningValue, PasswordPolicyErrorType errorType) {
        this.isCritical = isCritical;
        this.warningType = warningType;
        this.warningValue = warningValue;
        this.errorType = errorType;
    }

    public PasswordPolicyErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        Asn1Writer writer = Asn1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            if (this.warningType != null) {
                writer.writeStartSequence((byte)-96);
                writer.writeInteger((byte)(0x80 | this.warningType.intValue()), this.warningValue);
                writer.writeEndSequence();
            }
            if (this.errorType != null) {
                writer.writeInteger((byte)-127, this.errorType.intValue());
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public PasswordPolicyWarningType getWarningType() {
        return this.warningType;
    }

    public int getWarningValue() {
        return this.warningValue;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PasswordPolicyResponseControl(oid=");
        builder.append(this.getOid());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        if (this.warningType != null) {
            builder.append(", warningType=");
            builder.append((Object)this.warningType);
            builder.append(", warningValue=");
            builder.append(this.warningValue);
        }
        if (this.errorType != null) {
            builder.append(", errorType=");
            builder.append((Object)this.errorType);
        }
        builder.append(")");
        return builder.toString();
    }
}

