/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ModificationType {
    private static final ModificationType[] ELEMENTS = new ModificationType[4];
    private static final List<ModificationType> IMMUTABLE_ELEMENTS = Collections.unmodifiableList(Arrays.asList(ELEMENTS));
    public static final ModificationType ADD = ModificationType.register(0, "add", Enum.ADD);
    public static final ModificationType DELETE = ModificationType.register(1, "delete", Enum.DELETE);
    public static final ModificationType REPLACE = ModificationType.register(2, "replace", Enum.REPLACE);
    public static final ModificationType INCREMENT = ModificationType.register(3, "increment", Enum.INCREMENT);
    private final int intValue;
    private final String name;
    private final Enum modificationTypeEnum;

    public static ModificationType valueOf(int intValue) {
        ModificationType result = null;
        if (0 <= intValue && intValue < ELEMENTS.length) {
            result = ELEMENTS[intValue];
        }
        if (result == null) {
            result = new ModificationType(intValue, "unknown(" + intValue + ")", Enum.UNKNOWN);
        }
        return result;
    }

    public static List<ModificationType> values() {
        return IMMUTABLE_ELEMENTS;
    }

    private static ModificationType register(int intValue, String name, Enum modificationTypeEnum) {
        ModificationType t;
        ModificationType.ELEMENTS[intValue] = t = new ModificationType(intValue, name, modificationTypeEnum);
        return t;
    }

    private ModificationType(int intValue, String name, Enum modificationTypeEnum) {
        this.intValue = intValue;
        this.name = name;
        this.modificationTypeEnum = modificationTypeEnum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ModificationType) {
            return this.intValue == ((ModificationType)obj).intValue;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public Enum asEnum() {
        return this.modificationTypeEnum;
    }

    public String toString() {
        return this.name;
    }

    public static enum Enum {
        ADD,
        DELETE,
        REPLACE,
        INCREMENT,
        UNKNOWN;

    }
}

