/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.json.jose.exceptions.InvalidJwtException;
import org.forgerock.util.encode.Base64url;

public final class Utils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true).configure(SerializationFeature.INDENT_OUTPUT, false);
    public static final Charset CHARSET = StandardCharsets.UTF_8;

    private Utils() {
    }

    public static String base64urlEncode(String s) {
        return Base64url.encode(s.getBytes(CHARSET));
    }

    public static String base64urlDecode(String s) {
        return new String(Base64url.decode(s), CHARSET);
    }

    public static boolean constantEquals(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < a.length; ++i) {
            result &= a[i] == b[i];
        }
        return result;
    }

    public static Map<String, Object> parseJson(String json) {
        try {
            return OBJECT_MAPPER.readValue(json, LinkedHashMap.class);
        }
        catch (IOException e) {
            throw new InvalidJwtException("Failed to parse json: " + e.getMessage(), e);
        }
    }

    public static String writeJsonObject(Map<String, Object> object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new InvalidJwtException("Failed to write json: " + e, e);
        }
    }

    public static byte[] sha256(byte[] data) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

