/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws;

import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import org.forgerock.json.jose.jwk.EcJWK;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.OctJWK;
import org.forgerock.json.jose.jwk.RsaJWK;
import org.forgerock.json.jose.jws.handlers.ECDSASigningHandler;
import org.forgerock.json.jose.jws.handlers.HmacSigningHandler;
import org.forgerock.json.jose.jws.handlers.NOPSigningHandler;
import org.forgerock.json.jose.jws.handlers.RSASigningHandler;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.util.SignatureUtil;

public class SigningManager {
    private final SignatureUtil signatureUtil = SignatureUtil.getInstance();

    public SigningHandler newNopSigningHandler() {
        return new NOPSigningHandler();
    }

    public SigningHandler newHmacSigningHandler(byte[] sharedSecret) {
        return new HmacSigningHandler(sharedSecret);
    }

    public SigningHandler newRsaSigningHandler(Key key) {
        return new RSASigningHandler(key, this.signatureUtil);
    }

    public SigningHandler newEcdsaSigningHandler(ECPrivateKey key) {
        return new ECDSASigningHandler(key);
    }

    public SigningHandler newEcdsaVerificationHandler(ECPublicKey key) {
        return new ECDSASigningHandler(key);
    }

    public SigningHandler newSigningHandler(Key key) {
        if (key instanceof ECPrivateKey) {
            return this.newEcdsaSigningHandler((ECPrivateKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return this.newRsaSigningHandler(key);
        }
        if (key instanceof SecretKey) {
            return this.newHmacSigningHandler(key.getEncoded());
        }
        throw new IllegalArgumentException("No signing handler found for this key algorithm: " + key.getAlgorithm());
    }

    public SigningHandler newSigningHandler(JWK jwk) {
        KeyType keyType = jwk.getKeyType();
        switch (keyType) {
            case RSA: {
                return this.newRsaSigningHandler(((RsaJWK)jwk).toRSAPrivateKey());
            }
            case EC: {
                return this.newEcdsaSigningHandler(((EcJWK)jwk).toECPrivateKey());
            }
            case OCT: {
                return this.newHmacSigningHandler(((OctJWK)jwk).toSecretKey().getEncoded());
            }
        }
        throw new IllegalArgumentException("No signing handler found for this key type: " + (Object)((Object)keyType));
    }

    public SigningHandler newVerificationHandler(Key key) {
        if (key instanceof ECPublicKey) {
            return this.newEcdsaVerificationHandler((ECPublicKey)key);
        }
        if (key instanceof RSAPublicKey) {
            return this.newRsaSigningHandler(key);
        }
        if (key instanceof SecretKey) {
            return this.newHmacSigningHandler(key.getEncoded());
        }
        throw new IllegalArgumentException("No verification handler found for this key algorithm: " + key.getAlgorithm());
    }

    public SigningHandler newVerificationHandler(JWK jwk) {
        KeyType keyType = jwk.getKeyType();
        switch (keyType) {
            case RSA: {
                return this.newRsaSigningHandler(((RsaJWK)jwk).toRSAPublicKey());
            }
            case EC: {
                return this.newEcdsaVerificationHandler(((EcJWK)jwk).toECPublicKey());
            }
            case OCT: {
                return this.newHmacSigningHandler(((OctJWK)jwk).toSecretKey().getEncoded());
            }
        }
        throw new IllegalArgumentException("No verification handler found for this key type: " + (Object)((Object)keyType));
    }
}

