/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe.handlers.encryption;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.forgerock.json.jose.exceptions.JweDecryptionException;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweEncryption;
import org.forgerock.json.jose.jwe.handlers.encryption.ContentEncryptionHandler;
import org.forgerock.util.Reject;

final class ChaCha20Poly1305ContentEncryptionHandler
extends ContentEncryptionHandler {
    private static final int KEY_SIZE = EncryptionMethod.CC20_P1305.getKeySize() / 8;
    private static final int HCHACHA20_ROUNDS = 20;
    private static final int CHACHA20_BLOCKSIZE = 64;
    private static final int NONCE_LENGTH = 12;
    private static final byte[] ALL_ZERO_MESSAGE_BLOCK = new byte[64];
    private final EncryptionMethod encryptionMethod;

    ChaCha20Poly1305ContentEncryptionHandler(EncryptionMethod encryptionMethod) {
        Reject.ifFalse(encryptionMethod == EncryptionMethod.CC20_P1305 || encryptionMethod == EncryptionMethod.XC20_P1305, "not a ChaCha20-Poly1305 encryption mode");
        this.encryptionMethod = encryptionMethod;
        try {
            Cipher.getInstance(encryptionMethod.getEncryptionAlgorithm()).init(1, (Key)new SecretKeySpec(new byte[KEY_SIZE], encryptionMethod.getEncryptionAlgorithm()), new IvParameterSpec(new byte[12]));
            Mac.getInstance(encryptionMethod.getMacAlgorithm());
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException("ChaCha20-Poly1305 not supported: please install Bouncy Castle", e);
        }
    }

    @Override
    JweEncryption encrypt(Key key, byte[] iv, byte[] plainText, byte[] additionalData) {
        Key encKey = this.deriveEncKey(key, iv);
        Cipher cipher = this.getCipher(1, encKey, this.nonce(iv));
        Key macKey = this.deriveMacKey(cipher);
        Mac mac = this.getMac(macKey);
        try {
            byte[] cipherText = cipher.doFinal(plainText);
            mac.update(additionalData);
            mac.update(ChaCha20Poly1305ContentEncryptionHandler.pad16(additionalData.length));
            mac.update(cipherText);
            mac.update(ChaCha20Poly1305ContentEncryptionHandler.pad16(cipherText.length));
            mac.update(ChaCha20Poly1305ContentEncryptionHandler.lengths(additionalData.length, cipherText.length));
            byte[] tag = mac.doFinal();
            return new JweEncryption(cipherText, tag);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    byte[] decrypt(Key key, byte[] iv, JweEncryption cipherText, byte[] additionalData) {
        Key encKey = this.deriveEncKey(key, iv);
        Cipher cipher = this.getCipher(1, encKey, this.nonce(iv));
        Key macKey = this.deriveMacKey(cipher);
        Mac mac = this.getMac(macKey);
        try {
            mac.update(additionalData);
            mac.update(ChaCha20Poly1305ContentEncryptionHandler.pad16(additionalData.length));
            mac.update(cipherText.getCiphertext());
            mac.update(ChaCha20Poly1305ContentEncryptionHandler.pad16(cipherText.getCiphertext().length));
            mac.update(ChaCha20Poly1305ContentEncryptionHandler.lengths(additionalData.length, cipherText.getCiphertext().length));
            byte[] tag = mac.doFinal();
            if (!MessageDigest.isEqual(tag, cipherText.getAuthenticationTag())) {
                throw new JweDecryptionException();
            }
            return cipher.doFinal(cipherText.getCiphertext());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
    }

    private Cipher getCipher(int mode, Key key, byte[] iv) {
        try {
            Cipher cipher = Cipher.getInstance(this.encryptionMethod.getEncryptionAlgorithm());
            cipher.init(mode, key, new IvParameterSpec(iv));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to get ChaCha20 cipher: please install Bouncy Castle", e);
        }
    }

    private Key deriveMacKey(Cipher cipher) {
        byte[] keyStream = cipher.update(ALL_ZERO_MESSAGE_BLOCK);
        return new SecretKeySpec(Arrays.copyOf(keyStream, KEY_SIZE), this.encryptionMethod.getMacAlgorithm());
    }

    private Key deriveEncKey(Key key, byte[] iv) {
        if (this.encryptionMethod == EncryptionMethod.XC20_P1305) {
            return HChaCha20Core.deriveSubKey(key, iv);
        }
        return key;
    }

    private byte[] nonce(byte[] iv) {
        if (this.encryptionMethod == EncryptionMethod.XC20_P1305) {
            byte[] subNonce = new byte[12];
            System.arraycopy(iv, 16, subNonce, 4, 8);
            return subNonce;
        }
        return iv;
    }

    private Mac getMac(Key macKey) {
        try {
            Mac mac = Mac.getInstance(this.encryptionMethod.getMacAlgorithm());
            mac.init(macKey);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to get Poly1305 MAC: please install Bouncy Castle", e);
        }
    }

    private static byte[] pad16(int length) {
        return new byte[16 - (length & 0xF) & 0xF];
    }

    private static byte[] lengths(int aadLength, int cipherTextLength) {
        ByteBuffer buffer = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN);
        return buffer.putLong(aadLength).putLong(cipherTextLength).array();
    }

    @Override
    Key generateEncryptionKey() {
        try {
            return KeyGenerator.getInstance(this.encryptionMethod.getEncryptionAlgorithm()).generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to get ChaCha20 KeyGenerator: please install Bouncy Castle", e);
        }
    }

    @Override
    public int getIVByteLength() {
        return this.encryptionMethod == EncryptionMethod.XC20_P1305 ? 24 : 12;
    }

    static class HChaCha20Core {
        private static final int[] OUTPUT_INDICES = new int[]{0, 1, 2, 3, 12, 13, 14, 15};

        HChaCha20Core() {
        }

        static Key deriveSubKey(Key key, byte[] iv) {
            int[] initialState = HChaCha20Core.initialState(key, iv);
            int[] output = new int[initialState.length];
            ChaChaEngine.chachaCore((int)20, (int[])initialState, (int[])output);
            for (int i = 0; i < initialState.length; ++i) {
                int n = i;
                output[n] = output[n] - initialState[i];
            }
            return HChaCha20Core.subKey(output);
        }

        private static int[] initialState(Key key, byte[] nonce) {
            int i;
            int[] state = new int[16];
            state[0] = 1634760805;
            state[1] = 857760878;
            state[2] = 2036477234;
            state[3] = 1797285236;
            ByteBuffer buffer = ByteBuffer.wrap(key.getEncoded()).order(ByteOrder.LITTLE_ENDIAN);
            for (i = 4; i < 12; ++i) {
                state[i] = buffer.getInt();
            }
            buffer = ByteBuffer.wrap(nonce).order(ByteOrder.LITTLE_ENDIAN);
            for (i = 12; i < 16; ++i) {
                state[i] = buffer.getInt();
            }
            return state;
        }

        private static Key subKey(int[] chachaOutputState) {
            ByteBuffer buffer = ByteBuffer.allocate(32).order(ByteOrder.LITTLE_ENDIAN);
            for (int index : OUTPUT_INDICES) {
                buffer.putInt(chachaOutputState[index]);
            }
            return new SecretKeySpec(buffer.array(), "ChaCha7539");
        }
    }
}

