/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.builders;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.json.jose.jwt.JwtClaimsSet;
import org.forgerock.json.jose.jwt.JwtType;

public class JwtClaimsSetBuilder {
    private final Map<String, Object> claims = new HashMap<String, Object>();

    public JwtClaimsSetBuilder claim(String key, Object claim) {
        this.claims.put(key, claim);
        return this;
    }

    public JwtClaimsSetBuilder claims(Map<String, Object> claims) {
        this.claims.putAll(claims);
        return this;
    }

    public JwtClaimsSetBuilder typ(JwtType typ) {
        return this.claim("typ", (Object)typ);
    }

    public JwtClaimsSetBuilder jti(String jti) {
        return this.claim("jti", jti);
    }

    public JwtClaimsSetBuilder iss(String iss) {
        return this.claim("iss", iss);
    }

    public JwtClaimsSetBuilder iss(URI iss) {
        return this.claim("iss", iss);
    }

    public JwtClaimsSetBuilder sub(String sub) {
        return this.claim("sub", sub);
    }

    public JwtClaimsSetBuilder sub(URI sub) {
        return this.claim("sub", sub);
    }

    public JwtClaimsSetBuilder aud(List<String> aud) {
        return this.claim("aud", aud);
    }

    public JwtClaimsSetBuilder iat(Date iat) {
        return this.claim("iat", iat);
    }

    public JwtClaimsSetBuilder nbf(Date nbf) {
        return this.claim("nbf", nbf);
    }

    public JwtClaimsSetBuilder exp(Date exp) {
        return this.claim("exp", exp);
    }

    public JwtClaimsSet build() {
        return new JwtClaimsSet(this.claims);
    }
}

