/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonPatchValueTransformer;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.util.Reject;

public final class JsonPatch {
    public static final String MEDIA_TYPE = "application/json-patch";
    public static final JsonPointer OP_PTR = new JsonPointer("/op");
    public static final JsonPointer PATH_PTR = new JsonPointer("/path");
    public static final JsonPointer FROM_PTR = new JsonPointer("/from");
    public static final JsonPointer VALUE_PTR = new JsonPointer("/value");
    private static final JsonPatchValueTransformer DEFAULT_TRANSFORM = (target, op) -> {
        if (op.get(VALUE_PTR) != null) {
            return op.get(VALUE_PTR).getObject();
        }
        throw new JsonValueException(op, "expecting a value member");
    };

    public static JsonValue diff(JsonValue original, JsonValue target) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (JsonPatch.differentTypes(original, target)) {
            result.add(JsonPatch.op("replace", original.getPointer(), target));
        } else if (original.isMap()) {
            for (String key : original.keys()) {
                if (target.isDefined(key)) {
                    JsonValue diff = JsonPatch.diff(original.get(key), target.get(key));
                    if (diff.size() <= 0) continue;
                    result.addAll(diff.asList());
                    continue;
                }
                result.add(JsonPatch.op("remove", original.getPointer().child(key), null));
            }
            for (String key : target.keys()) {
                if (original.isDefined(key)) continue;
                result.add(JsonPatch.op("add", original.getPointer().child(key), target.get(key)));
            }
        } else if (original.isList()) {
            boolean replace = false;
            if (original.size() != target.size()) {
                replace = true;
            } else {
                Iterator<JsonValue> i1 = original.iterator();
                Iterator<JsonValue> i2 = target.iterator();
                while (i1.hasNext() && i2.hasNext()) {
                    if (JsonPatch.diff(i1.next(), i2.next()).size() <= 0) continue;
                    replace = true;
                    break;
                }
            }
            if (replace) {
                result.add(JsonPatch.op("replace", original.getPointer(), target));
            }
        } else if (!original.isNull() && !original.getObject().equals(target.getObject())) {
            result.add(JsonPatch.op("replace", original.getPointer(), target));
        }
        return new JsonValue(result);
    }

    public static boolean isEqual(JsonValue value, JsonValue other) {
        Reject.ifFalse(JsonPatch.isJsonPrimitive(value) && JsonPatch.isJsonPrimitive(other), "JsonPatch#isEqual only supports recognizable JSON primitives");
        if (JsonPatch.differentTypes(value, other)) {
            return false;
        }
        if (value.size() != other.size()) {
            return false;
        }
        if (value.isMap()) {
            for (String key : value.keys()) {
                if (other.isDefined(key) && JsonPatch.isEqual(value.get(key), other.get(key))) continue;
                return false;
            }
        } else if (value.isList()) {
            Iterator<JsonValue> i1 = value.iterator();
            Iterator<JsonValue> i2 = other.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (JsonPatch.isEqual(i1.next(), i2.next())) continue;
                return false;
            }
        } else if (!value.isNull() && !value.getObject().equals(other.getObject())) {
            return false;
        }
        return true;
    }

    private static boolean isJsonPrimitive(JsonValue value) {
        return value.isNull() || value.isBoolean() || value.isMap() || value.isList() || value.isNumber() || value.isString();
    }

    private static boolean differentTypes(JsonValue v1, JsonValue v2) {
        return !(v1.isNull() && v2.isNull() || v1.isMap() && v2.isMap() || v1.isList() && v2.isList() || v1.isString() && v2.isString() || v1.isNumber() && v2.isNumber() || v1.isBoolean() && v2.isBoolean());
    }

    private static HashMap<String, Object> op(String op, JsonPointer pointer, JsonValue value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(OP_PTR.leaf(), op);
        result.put(PATH_PTR.leaf(), pointer.toString());
        if (value != null) {
            result.put(VALUE_PTR.leaf(), value.copy().getObject());
        }
        return result;
    }

    public static void patch(JsonValue original, JsonValue patch) {
        JsonPatch.patch(original, patch, DEFAULT_TRANSFORM);
    }

    public static void patch(JsonValue original, JsonValue patch, JsonPatchValueTransformer transform) {
        for (JsonValue operation : patch.required().expect(List.class)) {
            if (!operation.isDefined("op")) {
                throw new JsonValueException(operation, "op not specified");
            }
            PatchOperation op = PatchOperation.valueOf(operation.get(OP_PTR));
            if (op == null) {
                throw new JsonValueException(operation, "invalid op specified");
            }
            op.execute(original, operation, transform);
        }
    }

    private static JsonValue parentValue(JsonPointer pointer, JsonValue target) {
        JsonValue result = null;
        JsonPointer parent = pointer.parent();
        if (parent != null && (result = target.get(parent)) == null) {
            throw new JsonException("parent value not found");
        }
        return result;
    }

    private JsonPatch() {
    }

    private static enum PatchOperation {
        ADD{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer modifyPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue parent = JsonPatch.parentValue(modifyPath, original);
                if (parent == null) {
                    if (original.getObject() != null) {
                        throw new JsonValueException(operation, "root value already exists");
                    }
                    original.setObject(transform.getTransformedValue(original, operation));
                } else {
                    try {
                        if (parent.isList()) {
                            try {
                                Integer index = Integer.valueOf(modifyPath.leaf());
                                parent.add(index, transform.getTransformedValue(original, operation));
                            }
                            catch (Exception e) {
                                parent.add(modifyPath.leaf(), transform.getTransformedValue(original, operation));
                            }
                        } else if (original.get(modifyPath) != null && original.get(modifyPath).isList()) {
                            JsonValue target = original.get(modifyPath);
                            target.asList().add(transform.getTransformedValue(original, operation));
                        } else {
                            parent.add(modifyPath.leaf(), transform.getTransformedValue(original, operation));
                        }
                    }
                    catch (JsonException je) {
                        throw new JsonValueException(operation, (Throwable)je);
                    }
                }
            }
        }
        ,
        REMOVE{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer modifyPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue parent = JsonPatch.parentValue(modifyPath, original);
                String leaf = modifyPath.leaf();
                if (parent == null) {
                    original.setObject(null);
                } else {
                    if (!parent.isDefined(leaf)) {
                        throw new JsonValueException(operation, "value to remove not found");
                    }
                    try {
                        parent.remove(leaf);
                    }
                    catch (JsonException je) {
                        throw new JsonValueException(operation, (Throwable)je);
                    }
                }
            }
        }
        ,
        REPLACE{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer modifyPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue parent = JsonPatch.parentValue(modifyPath, original);
                if (parent != null) {
                    String leaf = modifyPath.leaf();
                    if (!parent.isDefined(leaf)) {
                        throw new JsonValueException(operation, "value to replace not found");
                    }
                    parent.put(leaf, transform.getTransformedValue(original, operation));
                } else {
                    original.setObject(transform.getTransformedValue(original, operation));
                }
            }
        }
        ,
        MOVE{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer sourcePath = operation.get(FROM_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonPointer destPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue sourceParent = JsonPatch.parentValue(sourcePath, original);
                if (sourceParent == null) {
                    throw new JsonValueException(operation, "cannot move root object");
                }
                JsonValue object = sourceParent.get(sourcePath.leaf());
                JsonValue destParent = JsonPatch.parentValue(destPath, original);
                if (destParent == null) {
                    original.setObject(object);
                } else {
                    sourceParent.remove(sourcePath.leaf());
                    destParent.put(destPath.leaf(), (Object)object);
                }
            }
        }
        ,
        COPY{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer sourcePath = operation.get(FROM_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonPointer destPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue sourceParent = JsonPatch.parentValue(sourcePath, original);
                JsonValue object = sourceParent.get(sourcePath.leaf());
                JsonValue destParent = JsonPatch.parentValue(destPath, original);
                if (destParent == null) {
                    original.setObject(object);
                } else {
                    destParent.put(destPath.leaf(), (Object)object);
                }
            }
        }
        ,
        TEST{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonValue testValue;
                JsonPointer testPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue testTarget = JsonPatch.parentValue(testPath, original).get(testPath.leaf());
                if (JsonPatch.diff(testTarget, testValue = new JsonValue(transform.getTransformedValue(original, operation))).asList().size() > 0) {
                    throw new JsonValueException(operation, "test failed");
                }
            }
        };


        void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
            throw new JsonValueException(original, "unsupported operation");
        }

        static PatchOperation valueOf(JsonValue op) {
            return PatchOperation.valueOf(op.expect(String.class).asString().toUpperCase());
        }
    }
}

