/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.swagger;

import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.guava.common.base.Function;
import org.forgerock.guava.common.base.Strings;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.routing.Version;
import org.forgerock.http.swagger.SwaggerExtended;
import org.forgerock.http.swagger.SwaggerUtils;
import org.forgerock.http.util.Paths;

public class SwaggerApiProducer
implements ApiProducer<Swagger> {
    private final List<Scheme> schemes;
    private final String basePath;
    private final Info info;
    private final String host;

    public SwaggerApiProducer(Info info) {
        this(info, null, null, Collections.emptyList());
    }

    public SwaggerApiProducer(Info info, String basePath, String host, Scheme ... schemes) {
        this(info, basePath, host, Arrays.asList(schemes));
    }

    public SwaggerApiProducer(Info info, String basePath, String host, List<Scheme> schemes) {
        this.info = info;
        this.basePath = basePath;
        this.host = host;
        this.schemes = new ArrayList<Scheme>(schemes);
    }

    @Override
    public Swagger withPath(Swagger descriptor, String parentPath) {
        return this.transform(descriptor, new PathTransformer(parentPath));
    }

    @Override
    public Swagger withVersion(Swagger descriptor, Version version) {
        return this.transform(descriptor, new VersionTransformer(version));
    }

    private Swagger transform(Swagger descriptor, Function<Map<String, Path>, Map<String, Path>> transformer) {
        Swagger swagger = this.addApiInfo(SwaggerUtils.clone(descriptor));
        swagger.setPaths(transformer.apply(descriptor.getPaths()));
        return swagger;
    }

    @Override
    public Swagger merge(List<Swagger> descriptors) {
        descriptors = new ArrayList<Swagger>(descriptors);
        descriptors.removeAll(Collections.singletonList(null));
        if (descriptors.isEmpty()) {
            return null;
        }
        Swagger swagger = this.addApiInfo(new SwaggerExtended());
        for (Swagger descriptor : descriptors) {
            for (String string : this.ensureNotNull(descriptor.getConsumes())) {
                swagger.consumes(string);
            }
            for (String string : this.ensureNotNull(descriptor.getProduces())) {
                swagger.produces(string);
            }
            for (Tag tag : this.ensureNotNull(descriptor.getTags())) {
                swagger.addTag(tag);
            }
            for (Map.Entry entry : this.ensureNotNull(descriptor.getResponses()).entrySet()) {
                if (!this.isUndefinedEntry("response", entry, swagger.getResponses())) continue;
                swagger.response((String)entry.getKey(), (Response)entry.getValue());
            }
            for (Map.Entry entry : this.ensureNotNull(descriptor.getParameters()).entrySet()) {
                if (!this.isUndefinedEntry("parameter", entry, swagger.getParameters())) continue;
                swagger.addParameter((String)entry.getKey(), (Parameter)entry.getValue());
            }
            for (Map.Entry entry : this.ensureNotNull(descriptor.getVendorExtensions()).entrySet()) {
                if (!this.isUndefinedEntry("extension", entry, swagger.getVendorExtensions())) continue;
                swagger.vendorExtension((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : this.ensureNotNull(descriptor.getDefinitions()).entrySet()) {
                if (!this.isUndefinedEntry("definition", entry, swagger.getDefinitions())) continue;
                swagger.addDefinition((String)entry.getKey(), (Model)entry.getValue());
            }
            for (Map.Entry entry : this.ensureNotNull(descriptor.getPaths()).entrySet()) {
                this.validatePathNotDefined((String)entry.getKey(), this.ensureNotNull(swagger.getPaths()).keySet());
                swagger.path((String)entry.getKey(), (Path)entry.getValue());
            }
            for (SecurityRequirement securityRequirement : this.ensureNotNull(descriptor.getSecurity())) {
                swagger.security(securityRequirement);
            }
            Map<String, SecuritySchemeDefinition> schemeDefinitionMap = this.ensureNotNull(descriptor.getSecurityDefinitions());
            for (Map.Entry<String, SecuritySchemeDefinition> secDef : schemeDefinitionMap.entrySet()) {
                if (!this.isUndefinedEntry("security definition", secDef, swagger.getSecurityDefinitions())) continue;
                swagger.securityDefinition(secDef.getKey(), secDef.getValue());
            }
        }
        return swagger;
    }

    private <T> Map<String, T> ensureNotNull(Map<String, T> map) {
        return map == null ? Collections.emptyMap() : map;
    }

    private <T> List<T> ensureNotNull(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    @Override
    public Swagger addApiInfo(Swagger swagger) {
        if (this.info != null) {
            swagger.info(this.info.mergeWith(swagger.getInfo()));
        }
        return swagger.host(this.host).basePath(this.basePath).schemes(this.schemes);
    }

    private <V> boolean isUndefinedEntry(String entryType, Map.Entry<String, V> entry, Map<String, V> existing) {
        Object value;
        Object object = value = existing == null ? null : (Object)existing.get(entry.getKey());
        if (value == null) {
            return true;
        }
        if (value.equals(entry.getValue())) {
            return false;
        }
        throw new IllegalArgumentException("Duplicated key for " + entryType + " but different value. Already got " + value);
    }

    private void validatePathNotDefined(String path, Set<String> paths) {
        if (paths.contains(path)) {
            throw new IllegalArgumentException("Duplicated path");
        }
    }

    @Override
    public ApiProducer<Swagger> newChildProducer(String subPath) {
        return new SwaggerApiProducer(this.info, Strings.isNullOrEmpty(this.basePath) ? subPath : this.basePath + subPath, this.host, this.schemes);
    }

    private static class VersionTransformer
    implements Function<Map<String, Path>, Map<String, Path>> {
        public static final String PATH_FRAGMENT_MARKER = "#";
        public static final String PATH_FRAGMENT_COMPONENT_SEPARATOR = "_";
        private final Version version;

        VersionTransformer(Version version) {
            this.version = version;
        }

        @Override
        public Map<String, Path> apply(Map<String, Path> pathMap) {
            HashMap<String, Path> result = new HashMap<String, Path>(pathMap.size());
            for (Map.Entry<String, Path> entry : pathMap.entrySet()) {
                String key = entry.getKey();
                Path path = entry.getValue();
                HeaderParameter acceptVersionHeader = (HeaderParameter)((HeaderParameter)new HeaderParameter().name("Accept-API-Version"))._enum(Collections.singletonList("resource=" + this.version));
                path.addParameter(acceptVersionHeader);
                if (key.contains(PATH_FRAGMENT_MARKER)) {
                    result.put(key + PATH_FRAGMENT_COMPONENT_SEPARATOR + this.version, path);
                    continue;
                }
                result.put(key + PATH_FRAGMENT_MARKER + this.version, path);
            }
            return result;
        }
    }

    private static class PathTransformer
    implements Function<Map<String, Path>, Map<String, Path>> {
        private final String parentPath;

        PathTransformer(String parentPath) {
            this.parentPath = Paths.addLeadingSlash(Paths.removeTrailingSlash(parentPath));
        }

        @Override
        public Map<String, Path> apply(Map<String, Path> pathMap) {
            HashMap<String, Path> result = new HashMap<String, Path>(pathMap.size());
            for (Map.Entry<String, Path> entry : pathMap.entrySet()) {
                String key = entry.getKey();
                result.put(this.parentPath + Paths.addLeadingSlash(key), entry.getValue());
            }
            return result;
        }
    }
}

