/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.Collections;
import java.util.List;
import org.forgerock.http.header.AbstractSingleValuedHeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;

public class ContentLengthHeader
extends Header {
    public static final String NAME = "Content-Length";
    private long length;

    public static ContentLengthHeader valueOf(Message message) {
        return ContentLengthHeader.valueOf(HeaderUtil.parseSingleValuedHeader(message, NAME));
    }

    public static ContentLengthHeader valueOf(String string) {
        long length = -1L;
        if (string != null) {
            try {
                length = Long.parseLong(string);
                length = length >= 0L ? length : -1L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new ContentLengthHeader(length);
    }

    public ContentLengthHeader() {
        this(-1L);
    }

    public ContentLengthHeader(long length) {
        this.length = length;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        return this.length >= 0L ? Collections.singletonList(Long.toString(this.length)) : Collections.emptyList();
    }

    static class Factory
    extends AbstractSingleValuedHeaderFactory<ContentLengthHeader> {
        Factory() {
        }

        @Override
        public ContentLengthHeader parse(String value) {
            return ContentLengthHeader.valueOf(value);
        }

        @Override
        public ContentLengthHeader parse(Object value) throws MalformedHeaderException {
            if (value instanceof Number) {
                return new ContentLengthHeader(((Number)value).longValue());
            }
            return (ContentLengthHeader)super.parse(value);
        }
    }
}

