/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo;

import com.inwebo.InWeboProxyLdapManager;
import com.inwebo.StepUpManager;
import com.inwebo.client.GroupLookupUtils;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapClientContext;
import org.forgerock.opendj.ldap.LdapClientContextEventListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchResultReferenceIOException;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.GenericExtendedResult;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ResultHandler;

final class InWeboxProxyLdapBackend
implements RequestHandler<RequestContext>,
LdapClientContextEventListener,
StepUpManager {
    static final String BIND_LOGGER_NAME = "BIND_LOGGER";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Logger bind_logger = Logger.getLogger("BIND_LOGGER");
    private final ConnectionFactory factory;
    private Connection connection = null;
    private final InWeboProxyLdapManager proxyManager;
    private final ThreadPoolExecutor bindWorker;

    public InWeboxProxyLdapBackend(ConnectionFactory factory, InWeboProxyLdapManager proxyManager, ThreadPoolExecutor bindWorker) throws Exception {
        this.factory = factory;
        this.proxyManager = proxyManager;
        this.bindWorker = bindWorker;
    }

    @Override
    public void handleAdd(RequestContext requestContext, AddRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
        this.logger.log(Level.FINE, String.format("[handleAdd - %d] : %s", requestContext.getMessageId(), request.toString()));
        try {
            this.getConnection().addAsync(request, intermediateResponseHandler).thenOnResult((ResultHandler<Result>)resultHandler).thenOnException(resultHandler).thenOnException(e -> this.logger.log(Level.SEVERE, String.format("[handleAdd - %d] : %s", requestContext.getMessageId(), e.getMessage())));
        }
        catch (LdapException e2) {
            Result r = Responses.newResult(ResultCode.OTHER);
            r.setDiagnosticMessage(String.format("Error while processing LDAP query : %s", e2.getMessage()));
            resultHandler.handleException(LdapException.newLdapException(r));
        }
    }

    @Override
    public void handleBind(RequestContext requestContext, BindRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<BindResult> resultHandler) {
        this.bind_logger.log(Level.INFO, String.format("[handleBind - %d] : %s", requestContext.getMessageId(), request.toString()));
        if (request.getAuthenticationType() != -128) {
            this.bind_logger.log(Level.WARNING, String.format("[handleBind - %d] : non-SIMPLE authentication not supported: %s", requestContext.getMessageId(), request.getAuthenticationType()));
            resultHandler.handleException(LdapException.newLdapException(this.buildBindResult(ResultCode.PROTOCOL_ERROR)));
            return;
        }
        Connection[] ctx = new Connection[1];
        try {
            ctx[0] = this.getConnection();
        }
        catch (LdapException e) {
            this.bind_logger.log(Level.WARNING, String.format("[handleBind - %d] : Authentication to LDAP failed : Error while getting LDAP connection : %s", requestContext.getMessageId(), e.getMessage()), e);
            resultHandler.handleException(e);
            return;
        }
        BindResult[] result = new BindResult[1];
        try {
            result[0] = ctx[0].bind(request);
        }
        catch (LdapException e) {
            this.bind_logger.log(Level.WARNING, String.format("[handleBind - %d] : Authentication to LDAP failed : Error while processing LDAP bind query : %s", requestContext.getMessageId(), e.getMessage()), e);
            resultHandler.handleException(e);
            return;
        }
        this.bind_logger.log(Level.INFO, String.format("[handleBind - %d] : Authentication to LDAP succeed", requestContext.getMessageId()));
        if ("".equals(request.getName()) || this.proxyManager.isWhitelistedDN(request.getName())) {
            this.bind_logger.log(Level.INFO, String.format("[handleBind - %d] : No inWebo authentication needed for \"%s\", DN is whitelisted", requestContext.getMessageId(), request.getName()));
            resultHandler.handleResult(result[0]);
            return;
        }
        try {
            this.bindWorker.execute(() -> {
                String iwLogin;
                block13: {
                    String bindDnLogin = request.getName().split(",")[0];
                    String[] bindLoginElements = bindDnLogin.split("=");
                    String bindLoginAttribute = bindLoginElements[0];
                    String bindLogin = bindLoginElements[1];
                    boolean doStepUp = false;
                    try {
                        doStepUp = this.proxyManager.doStepUp(request.getName(), this);
                    }
                    catch (Exception e) {
                        this.bind_logger.log(Level.WARNING, String.format("[handleBind - %d] : Error while checking the stepup configuration for : %s", requestContext.getMessageId(), request.getName()), e);
                        resultHandler.handleException(LdapException.newLdapException(this.buildBindResult(ResultCode.OTHER)));
                        return;
                    }
                    if (!doStepUp) {
                        this.bind_logger.log(Level.INFO, String.format("[handleBind - %d] : No inWebo authentication needed for \"%s\"", requestContext.getMessageId(), request.getName()));
                        resultHandler.handleResult(result[0]);
                        return;
                    }
                    String ldapLoginAttribute = this.proxyManager.getInWeboLoginAttribute();
                    iwLogin = null;
                    if (ldapLoginAttribute.equalsIgnoreCase(bindLoginAttribute)) {
                        iwLogin = bindLogin;
                    } else {
                        SearchRequest search = Requests.newSearchRequest(request.getName(), SearchScope.BASE_OBJECT, "(objectClass=*)", ldapLoginAttribute);
                        try {
                            ConnectionEntryReader reader = ctx[0].search(search);
                            if (!reader.hasNext()) break block13;
                            SearchResultEntry entry = reader.readEntry();
                            if (entry.containsAttribute(ldapLoginAttribute, new Object[0])) {
                                iwLogin = entry.getAttribute(ldapLoginAttribute).firstValueAsString();
                                break block13;
                            }
                            this.bind_logger.log(Level.SEVERE, String.format("[handleBind - %d] : Authentication to LDAP failed : No attribute %s", requestContext.getMessageId(), ldapLoginAttribute));
                            resultHandler.handleException(LdapException.newLdapException(this.buildBindResult(ResultCode.INVALID_CREDENTIALS)));
                            return;
                        }
                        catch (LdapException e) {
                            this.bind_logger.log(Level.SEVERE, String.format("[handleBind - %d] : Authentication to LDAP failed : Error while processing LDAP search query : %s", requestContext.getMessageId(), e.getMessage()), e);
                            resultHandler.handleException(LdapException.newLdapException(this.buildBindResult(ResultCode.OTHER)));
                            return;
                        }
                        catch (SearchResultReferenceIOException e) {
                            this.bind_logger.log(Level.SEVERE, String.format("[handleBind - %d] : Authentication to LDAP failed : Error while processing LDAP search result : %s", requestContext.getMessageId(), e.getMessage()), e);
                            resultHandler.handleException(LdapException.newLdapException(this.buildBindResult(ResultCode.OTHER)));
                            return;
                        }
                    }
                }
                try {
                    if (this.proxyManager.getInWeboRestAuthenticator().authorizeByPush(this.proxyManager.cipherLogin(iwLogin), 60L, TimeUnit.SECONDS)) {
                        this.bind_logger.log(Level.INFO, String.format("[handleBind - %d] : Authentication inWebo for '%s' succeed", requestContext.getMessageId(), iwLogin));
                        resultHandler.handleResult(result[0]);
                    } else {
                        this.bind_logger.log(Level.INFO, String.format("[handleBind - %d] : Authentication inWebo for '%s' failed", requestContext.getMessageId(), iwLogin));
                        resultHandler.handleResult(this.buildBindResult(ResultCode.INVALID_CREDENTIALS));
                    }
                    return;
                }
                catch (Throwable t) {
                    this.bind_logger.log(Level.WARNING, String.format("[handleBind - %d] : Authentication inWebo for %s failed : Error while processing inWebo authorizeByPush : %s", requestContext.getMessageId(), iwLogin, t.getMessage()), t);
                    resultHandler.handleException(LdapException.newLdapException(this.buildBindResult(ResultCode.OTHER)));
                    return;
                }
            });
        }
        catch (Throwable t) {
            this.bind_logger.log(Level.SEVERE, String.format("[handleBind - %d] : Error while submitting task : %s", requestContext.getMessageId(), request.getName()), t);
            resultHandler.handleException(LdapException.newLdapException(this.buildBindResult(ResultCode.OTHER)));
            return;
        }
    }

    private BindResult buildBindResult(ResultCode resultCode) {
        BindResult r = Responses.newBindResult(resultCode);
        if (ResultCode.INVALID_CREDENTIALS.equals(resultCode)) {
            r.setDiagnosticMessage("Authentication error");
        } else {
            r.setResultCode(ResultCode.OTHER);
            r.setDiagnosticMessage("Error while processing LDAP request");
        }
        return r;
    }

    @Override
    public void handleCompare(RequestContext requestContext, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<CompareResult> resultHandler) {
        this.logger.log(Level.FINE, String.format("[handleCompare - %d] : %s", requestContext.getMessageId(), request.toString()));
        try {
            this.getConnection().compareAsync(request, intermediateResponseHandler).thenOnResult((ResultHandler<CompareResult>)resultHandler).thenOnException(resultHandler).thenOnException(e -> this.logger.log(Level.SEVERE, String.format("[handleCompare - %d] : %s", requestContext.getMessageId(), e.getMessage())));
        }
        catch (LdapException e2) {
            CompareResult r = Responses.newCompareResult(ResultCode.OTHER);
            r.setDiagnosticMessage(String.format("Error while processing LDAP query : %s", e2.getMessage()));
            resultHandler.handleException(LdapException.newLdapException(r));
        }
    }

    @Override
    public void handleDelete(RequestContext requestContext, DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
        this.logger.log(Level.FINE, String.format("[handleDelete - %d] : %s", requestContext.getMessageId(), request.toString()));
        try {
            this.getConnection().deleteAsync(request, intermediateResponseHandler).thenOnResult((ResultHandler<Result>)resultHandler).thenOnException(resultHandler).thenOnException(e -> this.logger.log(Level.SEVERE, String.format("[handleDelete - %d] : %s", requestContext.getMessageId(), e.getMessage())));
        }
        catch (LdapException e2) {
            Result r = Responses.newResult(ResultCode.OTHER);
            r.setDiagnosticMessage(String.format("Error while processing LDAP query : %s", e2.getMessage()));
            resultHandler.handleException(LdapException.newLdapException(r));
        }
    }

    @Override
    public <R extends ExtendedResult> void handleExtendedRequest(RequestContext requestContext, ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<R> resultHandler) {
        this.logger.log(Level.FINE, String.format("[handleExtendedRequest - %d] : %s", requestContext.getMessageId(), request.toString()));
        if ("1.3.6.1.1.8".equals(request.getOid())) {
            this.logger.info("Cancel extended request operation not supported");
            GenericExtendedResult r = Responses.newGenericExtendedResult(ResultCode.PROTOCOL_ERROR);
            r.setDiagnosticMessage("Cancel extended request operation not supported");
            resultHandler.handleResult((R)r);
        } else if ("1.3.6.1.4.1.1466.20037".equals(request.getOid())) {
            this.logger.info("StartTLS extended request operation not supported");
            GenericExtendedResult r = Responses.newGenericExtendedResult(ResultCode.PROTOCOL_ERROR);
            r.setDiagnosticMessage("StartTLS extended request operation not supported");
            resultHandler.handleResult((R)r);
        } else {
            try {
                this.getConnection().extendedRequestAsync(request, intermediateResponseHandler).thenOnResult((ResultHandler<R>)resultHandler).thenOnException(resultHandler).thenOnException(e -> this.logger.log(Level.SEVERE, String.format("[handleExtendedRequest - %d] : %s", requestContext.getMessageId(), e.getMessage())));
            }
            catch (LdapException e2) {
                GenericExtendedResult r = Responses.newGenericExtendedResult(ResultCode.OTHER);
                r.setDiagnosticMessage(String.format("Error while processing LDAP query : %s", e2.getMessage()));
                resultHandler.handleException(LdapException.newLdapException(r));
            }
        }
    }

    @Override
    public void handleModify(RequestContext requestContext, ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
        this.logger.log(Level.FINE, String.format("[handleModify - %d] : %s", requestContext.getMessageId(), request.toString()));
        try {
            this.getConnection().modifyAsync(request, intermediateResponseHandler).thenOnResult((ResultHandler<Result>)resultHandler).thenOnException(resultHandler).thenOnException(e -> this.logger.log(Level.SEVERE, String.format("[handleModify - %d] : %s", requestContext.getMessageId(), e.getMessage())));
        }
        catch (LdapException e2) {
            Result r = Responses.newResult(ResultCode.OTHER);
            r.setDiagnosticMessage(String.format("Error while processing LDAP query : %s", e2.getMessage()));
            resultHandler.handleException(LdapException.newLdapException(r));
        }
    }

    @Override
    public void handleModifyDn(RequestContext requestContext, ModifyDnRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
        this.logger.log(Level.FINE, String.format("[handleModifyDn - %d] : %s", requestContext.getMessageId(), request.toString()));
        try {
            this.getConnection().modifyDnAsync(request, intermediateResponseHandler).thenOnResult((ResultHandler<Result>)resultHandler).thenOnException(resultHandler).thenOnException(e -> this.logger.log(Level.SEVERE, String.format("[handleModifyDn - %d] : %s", requestContext.getMessageId(), e.getMessage())));
        }
        catch (LdapException e2) {
            Result r = Responses.newResult(ResultCode.OTHER);
            r.setDiagnosticMessage(String.format("Error while processing LDAP query : %s", e2.getMessage()));
            resultHandler.handleException(LdapException.newLdapException(r));
        }
    }

    @Override
    public void handleSearch(RequestContext requestContext, SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler, LdapResultHandler<Result> resultHandler) {
        this.logger.log(Level.FINE, String.format("[handleSearch - %d] : %s", requestContext.getMessageId(), request.toString()));
        try {
            this.getConnection().searchAsync(request, intermediateResponseHandler, entryHandler).thenOnResult((ResultHandler<Result>)resultHandler).thenOnException(resultHandler).thenOnException(e -> this.logger.log(Level.SEVERE, String.format("[handleSearch - %d] : %s", requestContext.getMessageId(), e.getMessage())));
        }
        catch (LdapException e2) {
            Result r = Responses.newResult(ResultCode.OTHER);
            r.setDiagnosticMessage(String.format("Error while processing LDAP query : %s", e2.getMessage()));
            resultHandler.handleException(LdapException.newLdapException(r));
        }
    }

    @Override
    public void handleConnectionError(LdapClientContext context, Throwable error) {
        this.logger.log(Level.WARNING, String.format("Error while processing LDAP query : %s", error.getMessage()), error);
        this.close(this.connection);
    }

    @Override
    public void handleConnectionDisconnected(LdapClientContext context, ResultCode resultCode, String diagnosticMessage) {
        this.logger.log(Level.WARNING, String.format("[handleConnectionDisconnected] %s %s : %s", context.toString(), resultCode.toString(), diagnosticMessage));
        this.connection = null;
    }

    @Override
    public void handleConnectionClosed(LdapClientContext context) {
        this.logger.log(Level.FINE, String.format("[handleConnectionClosed] %s", context.toString()));
        this.close(this.connection);
    }

    private void close(Connection c) {
        this.logger.log(Level.FINE, String.format("[close] %s", c != null ? c.toString() : "null"));
        Utils.closeSilently(c);
        this.connection = null;
    }

    private Connection getConnection() throws LdapException {
        if (this.connection != null && this.connection.isValid()) {
            return this.connection;
        }
        this.connection = this.factory.getConnection();
        return this.connection;
    }

    @Override
    public boolean doStepUp(String userDn, String groupDn, StepUpManager.StepUpType stepUptype, String memberAttribute, String isMemberOfAttribute, String groupObjectClass, String userObjectClass) throws Exception {
        this.logger.log(Level.FINE, String.format("[doStepUp] user to find : %s, group : ", userDn, groupDn));
        switch (stepUptype) {
            case USER: {
                return GroupLookupUtils.checkUserMemberShip(this.getConnection(), userDn, groupDn, isMemberOfAttribute, null, userObjectClass, groupObjectClass);
            }
            case GROUP: {
                return GroupLookupUtils.checkUserMemberShip(this.getConnection(), userDn, groupDn, null, memberAttribute, userObjectClass, groupObjectClass);
            }
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        return false;
    }
}

