/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.ldap.CoreMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.util.Reject;

final class PromptingTrustManager
implements X509TrustManager {
    private static final LocalizedLogger LOG = LocalizedLogger.getLoggerForThisClass();
    private static final String DEFAULT_PATH = System.getProperty("user.home") + File.separator + ".opendj" + File.separator + "keystore";
    private static final char[] DEFAULT_PASSWORD = "OpenDJ".toCharArray();
    private final ConsoleApplication app;
    private final X509TrustManager userProvidedTrustManager;
    private final KeyStore inMemoryTrustStore;
    private final X509TrustManager inMemoryTrustManager;
    private final KeyStore onDiskTrustStore;
    private final X509TrustManager onDiskTrustManager;

    PromptingTrustManager(ConsoleApplication app, X509TrustManager userProvidedTrustManager) throws IOException, GeneralSecurityException {
        Reject.ifNull(app);
        this.app = app;
        this.userProvidedTrustManager = userProvidedTrustManager;
        this.inMemoryTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.inMemoryTrustStore.load(null, null);
        this.inMemoryTrustManager = PromptingTrustManager.getX509TrustManager(this.inMemoryTrustStore);
        if (userProvidedTrustManager == null) {
            this.onDiskTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            File onDiskTrustStorePath = new File(DEFAULT_PATH);
            if (!onDiskTrustStorePath.exists()) {
                this.onDiskTrustStore.load(null, null);
            } else {
                try (FileInputStream fos = new FileInputStream(onDiskTrustStorePath);){
                    this.onDiskTrustStore.load(fos, DEFAULT_PASSWORD);
                }
            }
            this.onDiskTrustManager = PromptingTrustManager.getX509TrustManager(this.onDiskTrustStore);
        } else {
            this.onDiskTrustStore = null;
            this.onDiskTrustManager = null;
        }
    }

    private static X509TrustManager getX509TrustManager(KeyStore trustStore) throws GeneralSecurityException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new NoSuchAlgorithmException();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        try {
            this.inMemoryTrustManager.checkClientTrusted(x509Certificates, s);
        }
        catch (Exception ce1) {
            try {
                if (this.userProvidedTrustManager != null) {
                    this.userProvidedTrustManager.checkClientTrusted(x509Certificates, s);
                } else {
                    this.onDiskTrustManager.checkClientTrusted(x509Certificates, s);
                }
            }
            catch (Exception ce2) {
                this.checkManuallyTrusted(x509Certificates, ce2);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        try {
            this.inMemoryTrustManager.checkServerTrusted(x509Certificates, s);
        }
        catch (Exception ce1) {
            try {
                if (this.userProvidedTrustManager != null) {
                    this.userProvidedTrustManager.checkServerTrusted(x509Certificates, s);
                } else {
                    this.onDiskTrustManager.checkServerTrusted(x509Certificates, s);
                }
            }
            catch (Exception ce2) {
                this.checkManuallyTrusted(x509Certificates, ce2);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.userProvidedTrustManager != null) {
            return this.userProvidedTrustManager.getAcceptedIssuers();
        }
        return new X509Certificate[0];
    }

    /*
     * Unable to fully structure code
     */
    private void checkManuallyTrusted(X509Certificate[] chain, Exception exception) throws CertificateException {
        if (exception instanceof CertificateException) {
            this.app.println();
            this.app.println(CoreMessages.ERR_CERT_NOT_TRUSTED.get(chain[0].getSubjectX500Principal(), exception.getMessage()));
        }
        this.app.println();
        this.app.println(CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_SERVER_CERTIFICATE.get());
        this.app.println();
        for (X509Certificate element : chain) {
            this.app.println(CliMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE_USER_DN.get(element.getSubjectDN().toString()));
            this.app.println(CliMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE_VALIDITY.get(element.getNotBefore().toString(), element.getNotAfter().toString()));
            this.app.println(CliMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE_ISSUER.get(element.getIssuerDN().toString()));
            this.app.println();
            this.app.println();
        }
        this.app.println();
        this.app.println(CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION.get());
        this.app.println();
        menuOptions = new HashMap<String, TrustOption>();
        optionIndex = 1;
        defaultOption = 1;
        for (TrustOption t : TrustOption.values()) {
            if (this.onDiskTrustManager == null && t == TrustOption.PERMANENT) continue;
            if (t == TrustOption.SESSION) {
                defaultOption = optionIndex;
            }
            menuOptions.put(String.valueOf(optionIndex), t);
            builder = new LocalizableMessageBuilder();
            builder.append(optionIndex);
            builder.append(") ");
            builder.append(t.getMenuMessage());
            this.app.println(builder.toMessage(), 2);
            ++optionIndex;
        }
        promptMsg = CliMessages.INFO_MENU_PROMPT_SINGLE.get();
        block11: while (true) {
            this.app.println();
            try {
                choice = this.app.readInput(promptMsg, String.valueOf(defaultOption));
            }
            catch (ClientException e) {
                throw new CertificateException(exception);
            }
            finally {
                this.app.println();
            }
            option = (TrustOption)menuOptions.get(choice.trim());
            if (option == null) {
                this.app.println(CliMessages.ERR_MENU_BAD_CHOICE_SINGLE.get());
                this.app.println();
                continue;
            }
            switch (1.$SwitchMap$com$forgerock$opendj$cli$PromptingTrustManager$TrustOption[option.ordinal()]) {
                case 1: {
                    if (exception instanceof CertificateException) {
                        throw (CertificateException)exception;
                    }
                    throw new CertificateException(exception);
                }
                case 2: {
                    arr$ = chain;
                    len$ = arr$.length;
                    i$ = 0;
                    while (true) {
                        if (i$ < len$) ** break;
                        continue block11;
                        aChain = arr$[i$];
                        this.app.println();
                        this.app.println(CliMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE.get(aChain.toString()));
                        this.app.println();
                        ++i$;
                    }
                }
                default: {
                    this.acceptCertificate(chain, option == TrustOption.PERMANENT);
                    return;
                }
            }
            break;
        }
    }

    private void acceptCertificate(X509Certificate[] chain, boolean permanent) {
        if (permanent) {
            LOG.debug(LocalizableMessage.raw("Permanently accepting certificate chain to trust store", new Object[0]));
        } else {
            LOG.debug(LocalizableMessage.raw("Accepting certificate chain for this session", new Object[0]));
        }
        for (X509Certificate cert : chain) {
            try {
                String alias = cert.getSubjectDN().getName();
                this.inMemoryTrustStore.setCertificateEntry(alias, cert);
                if (!permanent) continue;
                this.onDiskTrustStore.setCertificateEntry(alias, cert);
            }
            catch (Exception e) {
                LOG.warn(LocalizableMessage.raw("Error setting certificate to store: %s\nCert: %s", e, cert));
            }
        }
        if (permanent) {
            try {
                File truststoreFile = new File(DEFAULT_PATH);
                if (!truststoreFile.exists()) {
                    File parent = truststoreFile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    truststoreFile.createNewFile();
                }
                try (FileOutputStream fos = new FileOutputStream(truststoreFile);){
                    this.onDiskTrustStore.store(fos, DEFAULT_PASSWORD);
                }
            }
            catch (Exception e) {
                LOG.warn(LocalizableMessage.raw("Error saving store to disk: %s", e));
            }
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$forgerock$opendj$cli$PromptingTrustManager$TrustOption;

        static {
            $SwitchMap$com$forgerock$opendj$cli$PromptingTrustManager$TrustOption = new int[TrustOption.values().length];
            try {
                1.$SwitchMap$com$forgerock$opendj$cli$PromptingTrustManager$TrustOption[TrustOption.UNTRUSTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$forgerock$opendj$cli$PromptingTrustManager$TrustOption[TrustOption.CERTIFICATE_DETAILS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static enum TrustOption {
        UNTRUSTED(CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION_NO.get()),
        SESSION(CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION_SESSION.get()),
        PERMANENT(CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION_ALWAYS.get()),
        CERTIFICATE_DETAILS(CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_CERTIFICATE_DETAILS.get());

        private LocalizableMessage msg;

        private TrustOption(LocalizableMessage msg) {
            this.msg = msg;
        }

        LocalizableMessage getMenuMessage() {
            return this.msg;
        }
    }
}

