/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.util.OperatingSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class CommandBuilder {
    private static final Set<Character> CHARS_TO_ESCAPE_IN_UNIX_CONSOLE = new TreeSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('|'), Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('$'), Character.valueOf('`'), Character.valueOf('\\'), Character.valueOf('\"'), Character.valueOf('\'')));
    private String commandName;
    private String subcommandName;
    private final List<Argument> args = new ArrayList<Argument>();
    private final Set<Argument> obfuscatedArgs = new HashSet<Argument>();
    public static final String LINE_SEPARATOR = OperatingSystem.isWindows() ? " " : " \\\n          ";
    public static final String HTML_LINE_SEPARATOR = OperatingSystem.isWindows() ? "&nbsp;" : "&nbsp;\\<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    public static String escapeCommandLineValue(String rawValue) {
        StringBuilder b = new StringBuilder();
        if (OperatingSystem.isUnix()) {
            for (int i = 0; i < rawValue.length(); ++i) {
                char c = rawValue.charAt(i);
                if (CHARS_TO_ESCAPE_IN_UNIX_CONSOLE.contains(Character.valueOf(c))) {
                    b.append('\\');
                }
                b.append(c);
            }
        } else {
            b.append('\"').append(rawValue).append('\"');
        }
        return b.toString();
    }

    public CommandBuilder() {
        this(null, null);
    }

    public CommandBuilder(String commandName, String subcommandName) {
        this.commandName = commandName;
        this.subcommandName = subcommandName;
    }

    public void setArgument(Argument argument) {
        this.setArgument(argument, null);
    }

    public void setArgument(Argument argument, Object value) {
        if (this.args.contains(argument)) {
            this.removeArgument(argument);
        }
        if (value != null) {
            argument.addValue(value.toString());
        }
        this.addArgument(argument);
    }

    public void setBooleanArgument(BooleanArgument argument, boolean isPresent) {
        if (isPresent) {
            this.addArgument(argument);
        } else {
            this.removeArgument(argument);
        }
    }

    public void addArgumentAndValue(Argument argument, Object value) {
        argument.addValue(value.toString());
        this.addArgument(argument);
    }

    void addArgumentsIfPresent(Argument ... arguments) {
        for (Argument argument : arguments) {
            if (!argument.isPresent()) continue;
            this.addArgument(argument);
        }
    }

    public void addArgument(Argument argument) {
        for (Argument arg : this.args) {
            if (arg == argument) {
                return;
            }
            if (!arg.equals(argument)) continue;
            if (arg.isMultiValued()) {
                for (String argValue : argument.getValues()) {
                    arg.addValue(argValue);
                }
            }
            return;
        }
        this.args.add(argument);
    }

    public void addObfuscatedArguments(Argument ... arguments) {
        for (Argument argument : arguments) {
            this.addObfuscatedArgument(argument);
        }
    }

    public void addObfuscatedArgument(Argument argument) {
        this.addArgument(argument);
        this.obfuscatedArgs.add(argument);
    }

    public boolean removeArgument(Argument argument) {
        this.obfuscatedArgs.remove(argument);
        return this.args.remove(argument);
    }

    public void removeArguments(Argument ... arguments) {
        for (Argument argument : arguments) {
            this.removeArgument(argument);
        }
    }

    public void append(CommandBuilder builder) {
        for (Argument arg : builder.args) {
            if (builder.isObfuscated(arg)) {
                this.addObfuscatedArgument(arg);
                continue;
            }
            this.addArgument(arg);
        }
    }

    public String toString() {
        return this.toString(false, LINE_SEPARATOR);
    }

    public String toString(String lineSeparator) {
        return this.toString(false, lineSeparator);
    }

    private String toString(boolean showObfuscated, String lineSeparator) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.commandName);
        if (this.subcommandName != null) {
            builder.append(" ").append(this.subcommandName);
        }
        for (Argument arg : this.args) {
            if ("useSsl".equals(arg.getLongIdentifier())) continue;
            String argName = arg.getLongIdentifier() != null ? "--" + arg.getLongIdentifier() : "-" + arg.getShortIdentifier();
            if (arg instanceof BooleanArgument) {
                builder.append(lineSeparator).append(argName);
                continue;
            }
            if (arg instanceof FileBasedArgument) {
                for (String value : ((FileBasedArgument)arg).getNameToValueMap().keySet()) {
                    builder.append(lineSeparator).append(argName).append(" ");
                    builder.append(this.getOutputValue(value, arg, showObfuscated));
                }
                continue;
            }
            for (String value : arg.getValues()) {
                builder.append(lineSeparator).append(argName).append(" ");
                builder.append(this.getOutputValue(value, arg, showObfuscated));
            }
        }
        return builder.toString();
    }

    private String getOutputValue(String value, Argument arg, boolean showObfuscated) {
        if (this.isObfuscated(arg) && !showObfuscated) {
            return "******";
        }
        return CommandBuilder.escapeCommandLineValue(value);
    }

    public void clearArguments() {
        this.args.clear();
        this.obfuscatedArgs.clear();
    }

    public List<Argument> getArguments() {
        return this.args;
    }

    public boolean isObfuscated(Argument argument) {
        return this.obfuscatedArgs.contains(argument);
    }
}

