/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentGroup;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.DocDescriptionSupplement;
import com.forgerock.opendj.cli.DocGenerationHelper;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolRefDocContainer;
import com.forgerock.opendj.cli.TrailingArgumentsConstraints;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.cli.VersionHandler;
import com.forgerock.opendj.util.StaticUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.i18n.slf4j.LocalizedLogger;

public class ArgumentParser
implements ToolRefDocContainer {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final Set<String> HOST_LONG_IDENTIFIERS = new HashSet<String>(Arrays.asList("hostname", "referencedHostname", "host1", "host2", "hostSource", "hostDestination"));
    static final char OPTION_SHORT_HELP_QUESTION_MARK = '?';
    static final String PROPERTY_SCRIPT_NAME = "com.forgerock.opendj.ldap.tools.scriptName";
    private static final String PROPERTY_SCRIPT_NAME_LEGACY = "org.opends.server.scriptName";
    private static final String DEFAULT_OPENDJ_CONFIG_DIR = ".opendj";
    private static final String DEFAULT_OPENDJ_PROPERTIES_FILE_NAME = "tools";
    private static final String DEFAULT_OPENDJ_PROPERTIES_FILE_EXTENSION = ".properties";
    private StringArgument propertiesFilePathArgument;
    private BooleanArgument noPropertiesFileArgument;
    private Argument usageArgument;
    private Argument versionArgument;
    private final List<String> trailingArguments = new ArrayList<String>();
    private final TrailingArgumentsConstraints trailingArgumentsConstraints;
    private boolean usageOrVersionDisplayed;
    private boolean versionPresent;
    private VersionHandler versionHandler = new VersionHandler(){

        @Override
        public void printVersion() {
        }

        public String toString() {
            return "<no version displayed>";
        }
    };
    private final Map<Character, Argument> shortIdMap = new HashMap<Character, Argument>();
    private final Map<String, Argument> longIdMap = new TreeMap<String, Argument>(String.CASE_INSENSITIVE_ORDER);
    private OutputStream usageOutputStream = System.out;
    private final String mainClassName;
    private final LocalizableMessage toolDescription;
    private LocalizableMessage shortToolDescription;
    final Set<ArgumentGroup> argumentGroupsForUsage = new TreeSet<ArgumentGroup>();
    private final ArgumentGroup defaultArgGroup = new ArgumentGroup(LocalizableMessage.EMPTY, Integer.MAX_VALUE);
    final ArgumentGroup ldapArgGroup = new ArgumentGroup(CliMessages.INFO_DESCRIPTION_LDAP_CONNECTION_ARGS.get(), -2147483646);
    protected final ArgumentGroup ioArgGroup = new ArgumentGroup(CliMessages.INFO_DESCRIPTION_IO_ARGS.get(), -2147483647);
    private final ArgumentGroup generalArgGroup = new ArgumentGroup(CliMessages.INFO_DESCRIPTION_GENERAL_ARGS.get(), Integer.MIN_VALUE);
    private Iterator<String> commandLineIterator;
    boolean parsingTrailingArguments;
    private static final String INDENT = "    ";
    private DocSubcommandDescriptionSupplement docToolDescriptionSupplement;
    private DocSubcommandDescriptionSupplement docSubcommandsDescriptionSupplement;

    public static String getBindPassword(StringArgument passwordArg, FileBasedArgument passwordFileArg) {
        if (passwordArg.isPresent()) {
            return passwordArg.getValue();
        }
        if (passwordFileArg.isPresent()) {
            return passwordFileArg.getValue();
        }
        return null;
    }

    static void fillArgumentsWithPropertiesIfNeeded(Properties argumentProperties, Collection<Argument> arguments) throws ArgumentException {
        for (Argument a : arguments) {
            if (!a.isPresent() && argumentProperties != null) {
                String value = argumentProperties.getProperty(a.getLongIdentifier().toLowerCase());
                LocalizableMessageBuilder invalidReason = new LocalizableMessageBuilder();
                if (value != null) {
                    boolean addValue;
                    boolean bl = addValue = a instanceof BooleanArgument || a.valueIsAcceptable(value, invalidReason);
                    if (addValue) {
                        a.addValue(value);
                        if (a.needsValue()) {
                            a.setPresent(true);
                        }
                        a.valueSetByProperty();
                    }
                }
            }
            if (a.isPresent() || !a.needsValue()) continue;
            if (a.getDefaultValue() != null) {
                a.addValue(a.getDefaultValue());
            }
            if (a.hasValue() || !a.isRequired()) continue;
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_VALUE_FOR_REQUIRED_ARG.get(a.getLongIdentifier()));
        }
    }

    public ArgumentParser(String mainClassName, LocalizableMessage toolDescription) {
        this(mainClassName, toolDescription, new TrailingArgumentsConstraints());
    }

    public ArgumentParser(String mainClassName, LocalizableMessage toolDescription, TrailingArgumentsConstraints trailingArgumentsConstraints) {
        this.mainClassName = mainClassName;
        this.toolDescription = toolDescription;
        this.trailingArgumentsConstraints = trailingArgumentsConstraints;
        this.initGroups();
    }

    public final <A extends Argument> A addArgument(A argument) {
        return this.addArgument(argument, this.getStandardGroup(argument));
    }

    public final <A extends Argument> A addDefaultArgument(A argument) {
        return this.addArgument(argument, this.defaultArgGroup);
    }

    public <A extends Argument> A addLdapConnectionArgument(A argument) {
        return this.addArgument(argument, this.ldapArgGroup);
    }

    public <A extends Argument> A addArgument(A argument, ArgumentGroup group) {
        String longId;
        Character shortId = argument.getShortIdentifier();
        if (shortId != null && this.shortIdMap.containsKey(shortId)) {
            String conflictingId = this.shortIdMap.get(shortId).getLongIdentifier();
            throw new IllegalArgumentException(CliMessages.ERR_ARGPARSER_DUPLICATE_SHORT_ID.get(argument.getLongIdentifier(), shortId, conflictingId).toString());
        }
        if (this.versionArgument != null && shortId != null && shortId.equals(this.versionArgument.getShortIdentifier())) {
            this.versionArgument = this.getVersionArgument(false);
            this.generalArgGroup.addArgument(this.versionArgument);
        }
        if (this.longIdMap.containsKey(longId = argument.getLongIdentifier())) {
            throw new IllegalArgumentException(CliMessages.ERR_ARGPARSER_DUPLICATE_LONG_ID.get(longId).toString());
        }
        if (shortId != null) {
            this.shortIdMap.put(shortId, argument);
        }
        this.longIdMap.put(longId, argument);
        if (group == null) {
            group = this.getStandardGroup(argument);
        }
        group.addArgument(argument);
        this.argumentGroupsForUsage.add(group);
        switch (longId) {
            case "propertiesFilePath": {
                this.propertiesFilePathArgument = (StringArgument)argument;
                break;
            }
            case "noPropertiesFile": {
                this.noPropertiesFileArgument = (BooleanArgument)argument;
            }
        }
        return argument;
    }

    private BooleanArgument getVersionArgument(boolean displayShortIdentifier) {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("version").shortIdentifier(displayShortIdentifier ? Character.valueOf('V') : null)).description(CliMessages.INFO_DESCRIPTION_PRODUCT_VERSION.get())).buildArgument();
    }

    final Properties checkExternalProperties() throws ArgumentException {
        String propertiesFilePath;
        if (this.noPropertiesFileArgument != null && this.noPropertiesFileArgument.isPresent()) {
            return null;
        }
        if (this.propertiesFilePathArgument == null) {
            return null;
        }
        if (this.propertiesFilePathArgument.isPresent()) {
            propertiesFilePath = this.propertiesFilePathArgument.getValue();
        } else {
            String userDir = System.getProperty("user.home");
            propertiesFilePath = this.findPropertiesFile(userDir + File.separator + DEFAULT_OPENDJ_CONFIG_DIR);
        }
        if (propertiesFilePath == null) {
            return null;
        }
        try {
            Properties argumentProperties = new Properties();
            String scriptName = this.getScriptName();
            Properties p = new Properties();
            try (FileInputStream fis = new FileInputStream(propertiesFilePath);){
                p.load(fis);
            }
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String currentPropertyName;
                String propertyName = currentPropertyName = (String)e.nextElement();
                if (scriptName != null) {
                    if (currentPropertyName.startsWith(scriptName)) {
                        propertyName = currentPropertyName.substring(scriptName.length() + 1);
                    } else if (p.containsKey(scriptName + "." + currentPropertyName)) continue;
                }
                argumentProperties.setProperty(propertyName.toLowerCase(), p.getProperty(currentPropertyName));
            }
            return argumentProperties;
        }
        catch (Exception e) {
            LocalizableMessage message = CliMessages.ERR_ARGPARSER_CANNOT_READ_PROPERTIES_FILE.get(propertiesFilePath, StaticUtils.getExceptionMessage(e));
            throw new ArgumentException(message, (Throwable)e);
        }
    }

    public final Argument getArgumentForLongId(String longId) {
        return this.longIdMap.get(longId);
    }

    public final Argument getArgumentForShortId(Character shortId) {
        return this.shortIdMap.get(shortId);
    }

    public final Collection<Argument> getArguments() {
        return this.longIdMap.values();
    }

    final String getMainClassName() {
        return this.mainClassName;
    }

    final ArgumentGroup getStandardGroup(Argument argument) {
        if (this.isInputOutputArgument(argument)) {
            return this.ioArgGroup;
        }
        if (this.isGeneralArgument(argument)) {
            return this.generalArgGroup;
        }
        if (this.isLdapConnectionArgument(argument)) {
            return this.ldapArgGroup;
        }
        return this.defaultArgGroup;
    }

    final LocalizableMessage getToolDescription() {
        return this.toolDescription;
    }

    @Override
    public final LocalizableMessage getShortToolDescription() {
        return this.shortToolDescription != null ? this.shortToolDescription : LocalizableMessage.EMPTY;
    }

    @Override
    public final void setShortToolDescription(LocalizableMessage shortDescription) {
        this.shortToolDescription = shortDescription;
    }

    @Override
    public final LocalizableMessage getDocToolDescriptionSupplement() {
        this.docToolDescriptionSupplement = this.constructIfNull(this.docToolDescriptionSupplement);
        return this.docToolDescriptionSupplement.getDocDescriptionSupplement();
    }

    @Override
    public final void setDocToolDescriptionSupplement(LocalizableMessage supplement) {
        this.docToolDescriptionSupplement = this.constructIfNull(this.docToolDescriptionSupplement);
        this.docToolDescriptionSupplement.setDocDescriptionSupplement(supplement);
    }

    @Override
    public final LocalizableMessage getDocSubcommandsDescriptionSupplement() {
        this.docSubcommandsDescriptionSupplement = this.constructIfNull(this.docSubcommandsDescriptionSupplement);
        return this.docSubcommandsDescriptionSupplement.getDocDescriptionSupplement();
    }

    @Override
    public final void setDocSubcommandsDescriptionSupplement(LocalizableMessage supplement) {
        this.docSubcommandsDescriptionSupplement = this.constructIfNull(this.docSubcommandsDescriptionSupplement);
        this.docSubcommandsDescriptionSupplement.setDocDescriptionSupplement(supplement);
    }

    private DocSubcommandDescriptionSupplement constructIfNull(DocSubcommandDescriptionSupplement supplement) {
        if (supplement != null) {
            return supplement;
        }
        return new DocSubcommandDescriptionSupplement();
    }

    public final List<String> getTrailingArguments() {
        return this.trailingArguments;
    }

    public String getUsage() {
        StringBuilder buffer = new StringBuilder();
        this.usageOrVersionDisplayed = true;
        if (System.getProperty("org.forgerock.opendj.gendoc") != null) {
            this.toRefEntry(buffer, this.getSynopsisArgs());
        } else {
            this.getUsage(buffer);
        }
        return buffer.toString();
    }

    String getSynopsisArgs() {
        return this.trailingArgumentsConstraints.getSynopsisArgs();
    }

    private void toRefEntry(StringBuilder builder, String synopsisArgs) {
        String scriptName = this.getScriptName();
        if (scriptName == null) {
            throw new IllegalStateException("The script name should have been set via the environment property 'com.forgerock.opendj.ldap.tools.scriptName'.");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("locale", Locale.getDefault().getLanguage());
        map.put("year", new SimpleDateFormat("yyyy").format(new Date()));
        map.put("name", scriptName);
        map.put("shortDesc", this.getShortToolDescription());
        map.put("descTitle", CliMessages.REF_TITLE_DESCRIPTION.get());
        map.put("args", synopsisArgs);
        map.put("description", this.eolToNewPara(this.getToolDescription()));
        map.put("info", this.getDocToolDescriptionSupplement());
        if (!this.longIdMap.isEmpty()) {
            map.put("optionSection", this.getOptionsRefSect1(scriptName));
        }
        map.put("subcommands", null);
        map.put("trailingSectionString", System.getProperty("org.forgerock.opendj.gendoc.trailing"));
        DocGenerationHelper.applyTemplate(builder, "refEntry.ftl", map);
    }

    final String eolToNewPara(LocalizableMessage input) {
        return input.toString().replaceAll(StaticUtils.EOL, "</para><para>");
    }

    final String getOptionsRefSect1(String scriptName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", scriptName);
        map.put("title", CliMessages.REF_TITLE_OPTIONS.get());
        map.put("intro", CliMessages.REF_INTRO_OPTIONS.get(scriptName));
        Argument helpArgument = null;
        boolean printHeaders = this.printUsageGroupHeaders();
        LinkedList groups = new LinkedList();
        for (ArgumentGroup argGroup : this.argumentGroupsForUsage) {
            HashMap<String, Object> group = new HashMap<String, Object>();
            if (argGroup.containsArguments() && printHeaders) {
                LocalizableMessage description = argGroup.getDescription();
                if (description != LocalizableMessage.EMPTY) {
                    group.put("description", this.eolToNewPara(description));
                } else {
                    group.put("description", CliMessages.INFO_SUBCMDPARSER_WHERE_OPTIONS_INCLUDE.get());
                }
            }
            LinkedList<Map<String, Object>> options = new LinkedList<Map<String, Object>>();
            SortedSet<Argument> args = this.sortArguments(argGroup.getArguments());
            for (Argument a : args) {
                if (a.isHidden()) continue;
                Map<String, Object> argumentMap = this.getArgumentMap(a);
                if (this.isHostNameArgument(a)) {
                    argumentMap.put("default", CliMessages.REF_DEFAULT.get("localhost.localdomain"));
                }
                if (a.getLongIdentifier().equals("backendType")) {
                    argumentMap.put("default", CliMessages.REF_DEFAULT_BACKEND_TYPE.get().toString());
                }
                if (this.isUsageArgument(a)) {
                    helpArgument = a;
                    continue;
                }
                options.add(argumentMap);
            }
            group.put("options", options);
            if (options.isEmpty()) continue;
            groups.add(group);
        }
        if (helpArgument != null) {
            HashMap helpGroup = new HashMap();
            helpGroup.put("description", null);
            LinkedList<Map<String, Object>> options = new LinkedList<Map<String, Object>>();
            options.add(this.getArgumentMap(helpArgument));
            helpGroup.put("options", options);
            groups.add(helpGroup);
        }
        map.put("groups", groups);
        StringBuilder sb = new StringBuilder();
        DocGenerationHelper.applyTemplate(sb, "optionsRefSect1.ftl", map);
        return sb.toString();
    }

    final boolean isHostNameArgument(Argument a) {
        return HOST_LONG_IDENTIFIERS.contains(a.getLongIdentifier());
    }

    private Map<String, Object> getArgumentMap(Argument a) {
        HashMap<String, Object> option = new HashMap<String, Object>();
        option.put("synopsis", DocGenerationHelper.getOptionSynopsis(a));
        option.put("description", this.eolToNewPara(a.getDescription()));
        String dv = a.getDefaultValue();
        option.put("default", dv != null ? CliMessages.REF_DEFAULT.get(dv) : null);
        option.put("info", a.getDocDescriptionSupplement());
        return option;
    }

    final void writeToUsageOutputStream(CharSequence message) {
        try {
            this.usageOutputStream.write(StaticUtils.getBytes(message.toString()));
        }
        catch (Exception e) {
            logger.traceException(e);
        }
    }

    private void getUsage(StringBuilder buffer) {
        buffer.append(this.getLocalizableScriptName());
        this.trailingArgumentsConstraints.append(buffer);
        buffer.append(StaticUtils.EOL);
        buffer.append(StaticUtils.EOL);
        if (this.toolDescription != null && this.toolDescription.length() > 0) {
            buffer.append(Utils.wrapText(this.toolDescription.toString(), Utils.MAX_LINE_WIDTH - 1));
            buffer.append(StaticUtils.EOL);
            buffer.append(StaticUtils.EOL);
        }
        buffer.append(CliMessages.INFO_SUBCMDPARSER_WHERE_OPTIONS_INCLUDE.get());
        buffer.append(StaticUtils.EOL);
        buffer.append(StaticUtils.EOL);
        Argument helpArgument = null;
        boolean printHeaders = this.printUsageGroupHeaders();
        for (ArgumentGroup argGroup : this.argumentGroupsForUsage) {
            LocalizableMessage groupDesc;
            if (argGroup.containsArguments() && printHeaders && (groupDesc = argGroup.getDescription()) != null && !LocalizableMessage.EMPTY.equals(groupDesc)) {
                buffer.append(StaticUtils.EOL);
                buffer.append(Utils.wrapText(groupDesc.toString(), Utils.MAX_LINE_WIDTH - 1));
                buffer.append(StaticUtils.EOL);
                buffer.append(StaticUtils.EOL);
            }
            SortedSet<Argument> args = this.sortArguments(argGroup.getArguments());
            for (Argument a : args) {
                if (a.isHidden()) continue;
                if (this.isUsageArgument(a)) {
                    helpArgument = a;
                    continue;
                }
                this.printArgumentUsage(a, buffer);
            }
        }
        if (helpArgument != null) {
            this.printArgumentUsage(helpArgument, buffer);
        } else {
            buffer.append(StaticUtils.EOL);
            buffer.append("-?");
            buffer.append(StaticUtils.EOL);
        }
    }

    private SortedSet<Argument> sortArguments(List<Argument> arguments) {
        TreeSet<Argument> result = new TreeSet<Argument>(new Comparator<Argument>(){

            @Override
            public int compare(Argument o1, Argument o2) {
                String s2;
                String s1 = this.getIdentifier(o1);
                int res = s1.compareToIgnoreCase(s2 = this.getIdentifier(o2));
                if (res != 0) {
                    return res;
                }
                return -s1.compareTo(s2);
            }

            private String getIdentifier(Argument o1) {
                if (o1.getShortIdentifier() != null) {
                    return o1.getShortIdentifier().toString();
                }
                return o1.getLongIdentifier();
            }
        });
        result.addAll(arguments);
        return result;
    }

    String getScriptNameOrJava() {
        String scriptName = this.getScriptName();
        if (scriptName != null && scriptName.length() != 0) {
            return scriptName;
        }
        return "java " + this.getMainClassName();
    }

    LocalizableMessage getLocalizableScriptName() {
        String scriptName = this.getScriptName();
        if (scriptName == null || scriptName.length() == 0) {
            return CliMessages.INFO_ARGPARSER_USAGE_JAVA_CLASSNAME.get(this.mainClassName);
        }
        return CliMessages.INFO_ARGPARSER_USAGE_JAVA_SCRIPTNAME.get(scriptName);
    }

    String getScriptName() {
        String scriptName = System.getProperty(PROPERTY_SCRIPT_NAME);
        if (scriptName != null && scriptName.length() != 0) {
            return scriptName;
        }
        String legacyScriptName = System.getProperty(PROPERTY_SCRIPT_NAME_LEGACY);
        if (legacyScriptName != null && legacyScriptName.length() != 0) {
            return legacyScriptName;
        }
        return null;
    }

    Argument getUsageArgument() {
        return this.usageArgument;
    }

    boolean isUsageArgument(Argument a) {
        return this.usageArgument != null && this.usageArgument.getLongIdentifier().equals(a.getLongIdentifier());
    }

    void printVersion() {
        this.versionPresent = true;
        this.usageOrVersionDisplayed = true;
        this.versionHandler.printVersion();
    }

    public boolean isUsageArgumentPresent() {
        return this.usageArgument != null && this.usageArgument.isPresent();
    }

    public boolean isVersionArgumentPresent() {
        return this.versionPresent;
    }

    public final void parseArguments(String[] rawArguments) throws ArgumentException {
        this.parseArguments(rawArguments, null);
    }

    public final void parseArguments(String[] rawArguments, String propertiesFile, boolean requirePropertiesFile) throws ArgumentException {
        Properties argumentProperties;
        block14: {
            argumentProperties = null;
            try (FileInputStream fis = new FileInputStream(propertiesFile);){
                Properties p = new Properties();
                p.load(fis);
                argumentProperties = p;
            }
            catch (Exception e) {
                if (!requirePropertiesFile) break block14;
                LocalizableMessage message = CliMessages.ERR_ARGPARSER_CANNOT_READ_PROPERTIES_FILE.get(propertiesFile, StaticUtils.getExceptionMessage(e));
                throw new ArgumentException(message, (Throwable)e);
            }
        }
        this.parseArguments(rawArguments, argumentProperties);
    }

    public final void parseArguments(String[] rawArguments, Properties argumentProperties) throws ArgumentException {
        List<String> arguments = this.initializeArgumentParsing(rawArguments);
        this.parsingTrailingArguments = false;
        for (String arg : arguments) {
            if (this.parsingTrailingArguments) {
                this.parseTrailingArgument(arg);
                continue;
            }
            if (arg.equals("--")) {
                this.parsingTrailingArguments = true;
            } else if (arg.startsWith("--")) {
                this.parseArgumentWithLongId(arg);
            } else if (arg.startsWith("-")) {
                this.parseArgumentWithShortId(arg);
            } else {
                this.parseTrailingArgument(arg);
            }
            if (!this.usageOrVersionDisplayed()) continue;
            return;
        }
        this.getTrailingArgumentsConstraints().checkMinTailingArgsProvided(this.trailingArguments);
        this.normalizeArguments(argumentProperties == null ? this.checkExternalProperties() : argumentProperties);
    }

    List<String> initializeArgumentParsing(String[] rawArguments) {
        return Arrays.asList(rawArguments);
    }

    void normalizeArguments(Properties properties) throws ArgumentException {
        ArgumentParser.fillArgumentsWithPropertiesIfNeeded(properties, this.getArguments());
    }

    void parseTrailingArgument(String arg) throws ArgumentException {
        this.parsingTrailingArguments = true;
        this.trailingArguments.add(arg);
        this.getTrailingArgumentsConstraints().checkAdditionalTrailingArgsAllowed(this.trailingArguments);
    }

    TrailingArgumentsConstraints getTrailingArgumentsConstraints() {
        return this.trailingArgumentsConstraints;
    }

    private void parseArgumentWithLongId(String rawArgumentWithDashes) throws ArgumentException {
        String rawArgument = rawArgumentWithDashes.substring(2);
        int equalPos = rawArgument.indexOf(61);
        if (equalPos == 0) {
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_LONG_ARG_WITHOUT_NAME.get(rawArgumentWithDashes));
        }
        boolean useEqualFormat = equalPos > 0;
        String argumentLongId = useEqualFormat ? rawArgument.substring(0, equalPos) : rawArgument;
        Argument argument = this.preProcessArgumentWithLongId(argumentLongId);
        if (this.usageOrVersionDisplayed()) {
            return;
        }
        if (argument.needsValue()) {
            String argValue = useEqualFormat ? rawArgument.substring(equalPos + 1) : this.readNextCommandLineValue(CliMessages.ERR_ARGPARSER_NO_VALUE_FOR_ARGUMENT_WITH_LONG_ID, argumentLongId);
            this.validateAndAddValue(argument, argumentLongId, argValue, CliMessages.ERR_ARGPARSER_VALUE_UNACCEPTABLE_FOR_LONG_ID, CliMessages.ERR_ARGPARSER_NOT_MULTIVALUED_FOR_LONG_ID);
        } else if (useEqualFormat) {
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_ARG_FOR_LONG_ID_DOESNT_TAKE_VALUE.get(argumentLongId));
        }
    }

    private Argument preProcessArgumentWithLongId(String argName) throws ArgumentException {
        Argument arg = this.retrieveArgumentWithLongId(argName);
        if (arg != null) {
            arg.setPresent(true);
            this.printUsageIfArgMatch(arg);
            return arg;
        }
        switch (argName.toLowerCase(Locale.ROOT)) {
            case "help": {
                this.writeToUsageOutputStream(this.getUsage());
                return null;
            }
            case "version": {
                this.printVersion();
                return null;
            }
        }
        throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_LONG_ID.get(argName));
    }

    Argument retrieveArgumentWithLongId(String argLongId) {
        return this.getArgumentForLongId(argLongId);
    }

    private void parseArgumentWithShortId(String rawArgumentWithDash) throws ArgumentException {
        if (rawArgumentWithDash.equals("-")) {
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_INVALID_DASH_AS_ARGUMENT.get());
        }
        char argShortId = rawArgumentWithDash.charAt(1);
        boolean useNoSpaceFormat = rawArgumentWithDash.length() > 2;
        Argument argument = this.preProcessArgumentWithShortId(argShortId);
        if (this.usageOrVersionDisplayed()) {
            return;
        }
        if (argument.needsValue()) {
            String argShortIdStr = String.valueOf(argShortId);
            String argValue = useNoSpaceFormat ? rawArgumentWithDash.substring(2) : this.readNextCommandLineValue(CliMessages.ERR_ARGPARSER_NO_VALUE_FOR_ARGUMENT_WITH_SHORT_ID, argShortIdStr);
            this.validateAndAddValue(argument, argShortIdStr, argValue, CliMessages.ERR_SUBCMDPARSER_VALUE_UNACCEPTABLE_FOR_SHORT_ID, CliMessages.ERR_SUBCMDPARSER_NOT_MULTIVALUED_FOR_SHORT_ID);
        } else if (useNoSpaceFormat) {
            String argValue = rawArgumentWithDash.substring(2);
            for (int i = 0; i < argValue.length(); ++i) {
                Argument b = this.preProcessArgumentWithShortId(argValue.charAt(i));
                if (this.usageOrVersionDisplayed()) {
                    return;
                }
                if (!b.needsValue()) continue;
                throw new ArgumentException(CliMessages.ERR_ARGPARSER_CANT_MIX_ARGS_WITH_VALUES.get(Character.valueOf(argShortId), argValue, b.getShortIdentifier()));
            }
        }
    }

    private Argument preProcessArgumentWithShortId(char argCharacter) throws ArgumentException {
        Argument argument = this.retrieveArgumentWithShortId(argCharacter);
        if (argument != null) {
            argument.setPresent(true);
            this.printUsageIfArgMatch(argument);
            return argument;
        }
        switch (argCharacter) {
            case '?': {
                this.processQuestionMarkArg();
                return null;
            }
            case 'V': {
                this.processShortProductVersionArg();
                return null;
            }
        }
        throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_SHORT_ID.get(Character.valueOf(argCharacter)));
    }

    void processQuestionMarkArg() {
        this.writeToUsageOutputStream(this.getUsage());
    }

    void processShortProductVersionArg() throws ArgumentException {
        if (this.versionHandler == null || this.shortIdMap.containsKey(Character.valueOf('V'))) {
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_SHORT_ID.get(Character.valueOf('V')));
        }
        this.printVersion();
    }

    Argument retrieveArgumentWithShortId(char argShortId) {
        return this.getArgumentForShortId(Character.valueOf(argShortId));
    }

    void printUsageIfArgMatch(Argument arg) {
        if (this.isUsageArgument(arg)) {
            this.writeToUsageOutputStream(this.getUsage());
        }
    }

    private void validateAndAddValue(Argument argument, String argId, String argValue, LocalizableMessageDescriptor.Arg3<Object, Object, Object> unacceptableValueErrMsg, LocalizableMessageDescriptor.Arg1<Object> argIsNotMultivaluedErrMsg) throws ArgumentException {
        LocalizableMessageBuilder invalidReason = new LocalizableMessageBuilder();
        if (!argument.valueIsAcceptable(argValue, invalidReason)) {
            throw new ArgumentException(unacceptableValueErrMsg.get(argValue, argId, invalidReason));
        }
        if (argument.hasValue() && !argument.isMultiValued()) {
            throw new ArgumentException(argIsNotMultivaluedErrMsg.get(argId));
        }
        argument.addValue(argValue);
    }

    private String readNextCommandLineValue(LocalizableMessageDescriptor.Arg1<Object> noValueErrMsg, String argId) throws ArgumentException {
        if (!this.commandLineIterator.hasNext()) {
            throw new ArgumentException(noValueErrMsg.get(argId));
        }
        return this.commandLineIterator.next();
    }

    boolean printUsageGroupHeaders() {
        int groupsContainingArgs = 0;
        for (ArgumentGroup argGroup : this.argumentGroupsForUsage) {
            if (!argGroup.containsNonHiddenArguments()) continue;
            ++groupsContainingArgs;
        }
        return groupsContainingArgs > 1;
    }

    public void setUsageArgument(BooleanArgument argument, OutputStream outputStream) {
        this.usageArgument = argument;
        this.usageOutputStream = outputStream;
    }

    public void setUsageOrVersionDisplayed(boolean usageOrVersionDisplayed) {
        this.usageOrVersionDisplayed = usageOrVersionDisplayed;
    }

    public void setVersionHandler(VersionHandler handler) {
        this.versionHandler = handler;
    }

    public boolean usageOrVersionDisplayed() {
        return this.usageOrVersionDisplayed;
    }

    private String findPropertiesFile(String directory) {
        File f = new File(directory, "tools.properties");
        if (f.exists() && f.canRead()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private void initGroups() {
        this.argumentGroupsForUsage.add(this.defaultArgGroup);
        this.argumentGroupsForUsage.add(this.ldapArgGroup);
        this.argumentGroupsForUsage.add(this.generalArgGroup);
        this.argumentGroupsForUsage.add(this.ioArgGroup);
        this.versionArgument = this.getVersionArgument(true);
        this.generalArgGroup.addArgument(this.versionArgument);
    }

    private boolean isGeneralArgument(Argument arg) {
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            return "help".equals(longId) || "version".equals(longId);
        }
        return false;
    }

    private boolean isInputOutputArgument(Argument arg) {
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            return "verbose".equals(longId) || "quiet".equals(longId) || "no-prompt".equals(longId) || "propertiesFilePath".equals(longId) || "noPropertiesFile".equals(longId) || "script-friendly".equals(longId) || "wrapColumn".equals(longId) || "encoding".equals(longId) || "batchFilePath".equals(longId);
        }
        return false;
    }

    private boolean isLdapConnectionArgument(Argument arg) {
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            return "useSsl".equals(longId) || "useStartTls".equals(longId) || "hostname".equals(longId) || "port".equals(longId) || "bindDn".equals(longId) || "bindPassword".equals(longId) || "bindPasswordFile".equals(longId) || "saslOption".equals(longId) || "trustAll".equals(longId) || "trustStorePath".equals(longId) || "trustStorePassword".equals(longId) || "trustStorePasswordFile".equals(longId) || "keyStorePath".equals(longId) || "keyStorePassword".equals(longId) || "keyStorePasswordFile".equals(longId) || "certNickname".equals(longId) || "referencedHostname".equals(longId) || "adminUid".equals(longId) || "reportAuthzId".equals(longId) || "usePasswordPolicyControl".equals(longId) || "useSaslExternal".equals(longId);
        }
        return false;
    }

    private void printArgumentUsage(Argument a, StringBuilder buffer) {
        this.printLineForShortLongArgument(a, buffer);
        int indentLength = INDENT.length();
        buffer.append(Utils.wrapText(a.getDescription(), Utils.MAX_LINE_WIDTH, indentLength));
        buffer.append(StaticUtils.EOL);
        if (a.needsValue() && a.getDefaultValue() != null && a.getDefaultValue().length() > 0) {
            buffer.append(INDENT);
            buffer.append(CliMessages.INFO_ARGPARSER_USAGE_DEFAULT_VALUE.get(a.getDefaultValue()));
            buffer.append(StaticUtils.EOL);
        }
    }

    void printLineForShortLongArgument(Argument a, StringBuilder buffer) {
        Character shortId = a.getShortIdentifier();
        String longId = a.getLongIdentifier();
        if (shortId != null) {
            if (this.isUsageArgument(a)) {
                buffer.append("-?, ");
            }
            buffer.append("-");
            buffer.append(shortId.charValue());
            if (a.needsValue() && longId == null) {
                buffer.append(" ");
                buffer.append(a.getValuePlaceholder());
            }
            if (longId != null) {
                StringBuilder newBuffer = new StringBuilder();
                newBuffer.append(", --");
                newBuffer.append(longId);
                if (a.needsValue()) {
                    newBuffer.append(" ");
                    newBuffer.append(a.getValuePlaceholder());
                }
                int currentLength = buffer.length();
                int lineLength = buffer.length() - currentLength + newBuffer.length();
                if (lineLength > Utils.MAX_LINE_WIDTH) {
                    buffer.append(StaticUtils.EOL);
                }
                buffer.append((CharSequence)newBuffer);
            }
            buffer.append(StaticUtils.EOL);
        } else if (longId != null) {
            if (this.isUsageArgument(a)) {
                buffer.append("-?, ");
            }
            buffer.append("--");
            buffer.append(longId);
            if (a.needsValue()) {
                buffer.append(" ");
                buffer.append(a.getValuePlaceholder());
            }
            buffer.append(StaticUtils.EOL);
        }
    }

    public final void displayMessageAndUsageReference(PrintStream printStream, LocalizableMessage message) {
        Utils.printWrappedText(printStream, message);
        printStream.println();
        Utils.printWrappedText(printStream, this.getHelpUsageReference());
    }

    private LocalizableMessage getHelpUsageReference() {
        this.setUsageOrVersionDisplayed(true);
        LocalizableMessageBuilder buffer = new LocalizableMessageBuilder();
        buffer.append(CliMessages.INFO_GLOBAL_HELP_REFERENCE.get(this.getScriptNameOrJava()));
        buffer.append(StaticUtils.EOL);
        return buffer.toMessage();
    }

    public final void replaceArgument(Argument argument) {
        String longId = argument.getLongIdentifier();
        if (!this.longIdMap.containsKey(longId)) {
            return;
        }
        this.longIdMap.put(longId, argument);
        this.shortIdMap.put(argument.getShortIdentifier(), argument);
        for (ArgumentGroup group : this.argumentGroupsForUsage) {
            if (!group.getArguments().contains(argument)) continue;
            group.removeArgument(argument);
            group.addArgument(argument);
        }
    }

    private class DocSubcommandDescriptionSupplement
    implements DocDescriptionSupplement {
        private LocalizableMessage docDescriptionSupplement;

        private DocSubcommandDescriptionSupplement() {
        }

        @Override
        public LocalizableMessage getDocDescriptionSupplement() {
            return this.docDescriptionSupplement != null ? this.docDescriptionSupplement : LocalizableMessage.EMPTY;
        }

        private void setDocDescriptionSupplement(LocalizableMessage docDescriptionSupplement) {
            this.docDescriptionSupplement = docDescriptionSupplement;
        }
    }
}

