/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.opendj.ldap.AttributeDescription;

public enum WritabilityPolicy {
    READ_ONLY("readOnly", false),
    READ_ONLY_DISCARD_WRITES("readOnlyDiscardWrites", true),
    CREATE_ONLY("createOnly", false),
    CREATE_ONLY_DISCARD_WRITES("createOnlyDiscardWrites", true),
    READ_WRITE("readWrite", false);

    private final String name;
    private final boolean discardWrites;

    private WritabilityPolicy(String name, boolean discardWrites) {
        this.name = name;
        this.discardWrites = discardWrites;
    }

    boolean canCreate(AttributeDescription attribute) {
        return this != READ_ONLY && !attribute.getAttributeType().isNoUserModification();
    }

    boolean canWrite(AttributeDescription attribute) {
        return this == READ_WRITE && !attribute.getAttributeType().isNoUserModification();
    }

    boolean discardWrites() {
        return this.discardWrites;
    }

    public String toString() {
        return this.name;
    }
}

