/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class DitStructureRule
extends AbstractSchemaElement {
    private final Integer ruleId;
    private final List<String> names;
    private final boolean isObsolete;
    private final String nameFormOid;
    private final Set<Integer> superiorRuleIds;
    private NameForm nameForm;
    private Set<DitStructureRule> superiorRules = Collections.emptySet();
    private boolean needsValidating = true;
    private boolean isValid;

    DitStructureRule(Builder builder) {
        super(builder);
        Reject.ifNull(builder.nameFormOid);
        this.ruleId = builder.ruleId;
        this.names = SchemaUtils.unmodifiableCopyOfList(builder.names);
        this.isObsolete = builder.isObsolete;
        this.nameFormOid = builder.nameFormOid;
        this.superiorRuleIds = SchemaUtils.unmodifiableCopyOfSet(builder.superiorRuleIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DitStructureRule) {
            DitStructureRule other = (DitStructureRule)o;
            return this.ruleId.equals(other.ruleId);
        }
        return false;
    }

    public NameForm getNameForm() {
        return this.nameForm;
    }

    public String getNameOrRuleId() {
        if (this.names.isEmpty()) {
            return this.ruleId.toString();
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public Integer getRuleId() {
        return this.ruleId;
    }

    public Set<DitStructureRule> getSuperiorRules() {
        return this.superiorRules;
    }

    @Override
    public int hashCode() {
        return this.ruleId.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        Iterator<Object> iterator;
        buffer.append(this.ruleId);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            String firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append((String)iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        this.appendDescription(buffer);
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" FORM ");
        buffer.append(this.nameFormOid);
        if (this.superiorRuleIds != null && !this.superiorRuleIds.isEmpty()) {
            iterator = this.superiorRuleIds.iterator();
            Integer firstRule = (Integer)iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" SUP ( ");
                buffer.append(firstRule);
                while (iterator.hasNext()) {
                    buffer.append(" ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" SUP ");
                buffer.append(firstRule);
            }
        }
    }

    boolean validate(Schema schema, List<DitStructureRule> invalidSchemaElements, List<LocalizableMessage> warnings) {
        if (!this.needsValidating) {
            return this.isValid;
        }
        this.needsValidating = false;
        try {
            this.nameForm = schema.getNameForm(this.nameFormOid);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_UNKNOWN_NAME_FORM.get(this.getNameOrRuleId(), this.nameFormOid);
            this.failValidation(invalidSchemaElements, warnings, message);
            return false;
        }
        if (!this.isObsolete() && this.nameForm.isObsolete()) {
            warnings.add(CoreMessages.WARN_DIT_SR_HAS_OBSOLETE_NAME_FORM.get(this.getNameOrRuleId(), this.nameFormOid));
        }
        if (!this.superiorRuleIds.isEmpty()) {
            this.superiorRules = new HashSet<DitStructureRule>(this.superiorRuleIds.size());
            for (Integer id : this.superiorRuleIds) {
                DitStructureRule ditStructureRule;
                try {
                    ditStructureRule = schema.getDitStructureRule(id);
                    this.superiorRules.add(ditStructureRule);
                }
                catch (UnknownSchemaElementException e) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_UNKNOWN_RULE_ID.get(this.getNameOrRuleId(), id);
                    this.failValidation(invalidSchemaElements, warnings, message);
                    return false;
                }
                if (this.isObsolete() || !ditStructureRule.isObsolete()) continue;
                warnings.add(CoreMessages.WARN_DIT_SR_HAS_OBSOLETE_SUPERIOR_RULE.get(this.getNameOrRuleId(), this.nameFormOid));
            }
        }
        this.superiorRules = Collections.unmodifiableSet(this.superiorRules);
        this.isValid = true;
        return true;
    }

    private void failValidation(List<DitStructureRule> invalidSchemaElements, List<LocalizableMessage> warnings, LocalizableMessage message) {
        invalidSchemaElements.add(this);
        warnings.add(CoreMessages.ERR_DSR_VALIDATION_FAIL.get(this.toString(), message));
    }

    public static final class Builder
    extends AbstractSchemaElement.SchemaElementBuilder<Builder> {
        private int ruleId;
        private final List<String> names = new LinkedList<String>();
        private boolean isObsolete;
        private String nameFormOid;
        private final Set<Integer> superiorRuleIds = new LinkedHashSet<Integer>();

        Builder(DitStructureRule structureRule, SchemaBuilder builder) {
            super(builder, structureRule);
            this.ruleId = structureRule.ruleId;
            this.names.addAll(structureRule.names);
            this.isObsolete = structureRule.isObsolete;
            this.nameFormOid = structureRule.nameFormOid;
            this.superiorRuleIds.addAll(structureRule.superiorRuleIds);
        }

        Builder(Integer ruleId, SchemaBuilder schemaBuilder) {
            super(schemaBuilder);
            this.ruleId = ruleId;
        }

        public SchemaBuilder addToSchema() {
            return this.getSchemaBuilder().addDitStructureRule(new DitStructureRule(this), false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.getSchemaBuilder().addDitStructureRule(new DitStructureRule(this), true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            return overwrite ? this.addToSchemaOverwrite() : this.addToSchema();
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public Builder nameForm(String nameFormOID) {
            this.nameFormOid = nameFormOID;
            return this;
        }

        public Builder names(Collection<String> names) {
            this.names.addAll(names);
            return this;
        }

        public Builder names(String ... names) {
            return this.names(Arrays.asList(names));
        }

        public Builder obsolete(boolean isObsolete) {
            this.isObsolete = isObsolete;
            return this;
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        public Builder removeAllNames() {
            this.names.clear();
            return this;
        }

        public Builder removeAllSuperiorRules() {
            this.superiorRuleIds.clear();
            return this;
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder removeName(String name) {
            this.names.remove(name);
            return this;
        }

        public Builder removeSuperiorRule(int superiorRuleId) {
            this.superiorRuleIds.remove(superiorRuleId);
            return this;
        }

        public Builder ruleId(int ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder superiorRules(int ... superiorRuleIds) {
            for (int ruleId : superiorRuleIds) {
                this.superiorRuleIds.add(ruleId);
            }
            return this;
        }

        Builder superiorRules(Collection<Integer> superiorRuleIds) {
            this.superiorRuleIds.addAll(superiorRuleIds);
            return this;
        }
    }
}

