/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.util.ReferenceCountedObject;
import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LdapServerFilter;
import org.forgerock.opendj.ldap.LdapClientContext;
import org.forgerock.opendj.ldap.LdapListener;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Response;
import org.forgerock.opendj.ldap.spi.LdapListenerImpl;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.nio.transport.TCPNIOBindingHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class GrizzlyLdapListener
implements LdapListenerImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final Option<?>[] MUTABLE_OPTIONS = new Option[]{LdapListener.SO_LINGER_IN_SECONDS, LdapListener.WRITE_TIMEOUT_MS, LdapListener.SO_KEEPALIVE, LdapListener.TCP_NO_DELAY, LdapListener.BUFFER_SIZE, LdapListener.REQUEST_MAX_SIZE_IN_BYTES, LdapListener.MAX_CONCURRENT_REQUESTS, LdapListener.LDAP_DECODE_OPTIONS, LdapListener.SSL_OPTIONS};
    private final ReferenceCountedObject.Reference<TCPNIOTransport> transport;
    private final Collection<TCPNIOServerConnection> serverConnections;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final Set<InetSocketAddress> socketAddresses;
    private final LdapServerFilter serverFilter;

    public GrizzlyLdapListener(Set<InetSocketAddress> addresses, Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> requestHandlerFactory, Options options, ReferenceCountedObject<TCPNIOTransport> refCountedTransport) throws IOException {
        this.transport = refCountedTransport.acquire();
        this.serverFilter = new LdapServerFilter(requestHandlerFactory, Options.unmodifiableCopyOf(options));
        FilterChain ldapChain = GrizzlyUtils.buildFilterChain(this.transport.get().getProcessor(), this.serverFilter);
        TCPNIOBindingHandler bindingHandler = ((TCPNIOBindingHandler.Builder)TCPNIOBindingHandler.builder(this.transport.get()).processor(ldapChain)).build();
        this.serverConnections = new ArrayList<TCPNIOServerConnection>(addresses.size());
        this.socketAddresses = new HashSet<InetSocketAddress>(addresses.size());
        for (InetSocketAddress address : addresses) {
            TCPNIOServerConnection bound = bindingHandler.bind(address);
            this.serverConnections.add(bound);
            this.socketAddresses.add((InetSocketAddress)bound.getLocalAddress());
        }
    }

    @Override
    public Options getOptions() {
        return this.serverFilter.getOptions();
    }

    @Override
    public boolean setOptions(Options newOptions) {
        Options overridden = Options.copyOf(this.getOptions());
        for (Option<?> o : MUTABLE_OPTIONS) {
            overridden.set(o, newOptions.get(o));
        }
        this.serverFilter.setOptions(Options.unmodifiableCopyOf(overridden));
        TCPNIOTransport transport = this.transport.get();
        transport.setLinger((Integer)overridden.get(LdapListener.SO_LINGER_IN_SECONDS));
        transport.setWriteTimeout(overridden.get(LdapListener.WRITE_TIMEOUT_MS), TimeUnit.MILLISECONDS);
        transport.setKeepAlive((Boolean)overridden.get(LdapListener.SO_KEEPALIVE));
        transport.setTcpNoDelay((Boolean)overridden.get(LdapListener.TCP_NO_DELAY));
        int bufferSize = overridden.get(LdapListener.BUFFER_SIZE);
        transport.setWriteBufferSize(bufferSize);
        transport.setReadBufferSize(bufferSize);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                for (TCPNIOConnection tCPNIOConnection : this.serverConnections) {
                    tCPNIOConnection.close().get();
                }
            }
            catch (Exception e) {
                logger.warn(LocalizableMessage.raw("Exception occurred while closing listener", e));
            }
            finally {
                this.transport.release();
            }
        }
    }

    @Override
    public Set<InetSocketAddress> getSocketAddresses() {
        return this.socketAddresses;
    }

    public String toString() {
        return "LDAPListener(" + this.socketAddresses + ')';
    }
}

